<?php

namespace App\Http\Controllers;

use App\Popup;
use Illuminate\Http\Request;
use Auth;
use Session;
use Validator;

class PopupController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
      
        if($user->can('index', \App\Popup::class))
        {
            $pop = Popup::all();
            if($pop->isEmpty())
            {
                $popup = $pop->toArray();
            }
            else
            {
                $popup = $pop;
            }
            return view('configuration.popups.index', compact('popup'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('create', \App\Popup::class))
        {
            return view('configuration.popups.create');
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try{

            $messages = [
                'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'popup_message' => 'required',
                'start'         => 'required',
                'end'           => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                Popup::create([

                    'popup_message' => $request->popup_message,
                    'start'         => $request->start,
                    'end'           => $request->end,

                ]);

                return redirect('/configuration/popup');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Popup  $popup
     * @return \Illuminate\Http\Response
     */
    public function show(Popup $popup)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Popup  $popup
     * @return \Illuminate\Http\Response
     */
    public function edit(Popup $popup)
    {
        $user = Auth::user();
        if($user->can('update', $popup))
        {
            return view('configuration.popups.edit', compact('popup'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Popup  $popup
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Popup $popup)
    {
        try{

            $messages = [
                'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'popup_message' => 'required',
                'start'         => 'required',
                'end'           => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                $user = Auth::user();
                if($user->can('update', $popup))
                {


                    $popup->update([

                        'popup_message' => $request->popup_message,
                        'start'         => $request->start,
                        'end'           => $request->end,

                    ]);

                    return redirect('/configuration/popup');
                }
                else
                {
                    return redirect()->back();
                }
            }
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Popup  $popup
     * @return \Illuminate\Http\Response
     */
    public function destroy(Popup $popup)
    {
        //
    }
}
