<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Visit;
use App\AccessColony;
use App\RecurrentEmploye;
use App\RecurrentVisit;
use DB;
use Auth;
use Carbon\Carbon;
use Session;
use App\Config;
use App\EmployeCategory;

class ReadQRController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
        if($user->can('index', \App\Guard::class))
        {
            Session::forget('message');
            return view('QRreader.index');
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        

        try{

            $user = Auth::user();
            if($user->can('index', \App\Guard::class))
            {

                $date = Carbon::now();
                $today = $date->toDateString();

                $permission = Config::all();

                foreach ($permission as $permissions) 
                {
                  $permission_guest = $permissions->guard_guest;
                  $permission_visit = $permissions->guard_visit;
                  $permission_employe = $permissions->guard_employe;
                }

                $caracter = substr_count($request->data, '/'); // 3 veces debe estar

                if($caracter != 3)
                {
                    $mensaje = 'QR inválido.';
                    Session::flash('message', $mensaje ); 
                    return redirect()->action('DashboardGuardController@index');  
                }


                //id
                $uno = Visit::cortar($request->data);
                $u = Visit::cortar2($request->data);
                //tipo recurente = 1, eventual = 2
                $dos = Visit::cortar($u);
                $d = Visit::cortar2($u); 
                //tipo de visita = 2 empleado, 3 visitante
                $tres = Visit::cortar($d);
                //fecha para la cual se dio acceso
                $cuatro = Visit::cortar2($d);
            


                // 1 = recurrente
                if($dos == 1)
                {
                    $dias = array('Domingo', 'Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
                    $fecha = $dias[date('N', strtotime($date->toDateString()))];
                    $diaccess = $dias[date('N', strtotime($cuatro))];
               
                    if($fecha == "Lunes"){$day = "monday";}
                    if($fecha == "Martes"){$day = "tuesday";}
                    if($fecha == "Miercoles"){$day = "wendsday";}
                    if($fecha == "Jueves"){$day = "thursday";}
                    if($fecha == "Viernes"){$day = "friday";}
                    if($fecha == "Sabado"){$day = "saturday";}
                    if($fecha == "Domingo"){$day = "sunday";}




                    if($tres == 2)
                    {


                        $access = RecurrentEmploye::join('employes','employe_id','=','employes.id')
                        ->join('employes_categories','category','=','employes_categories.id')
                        ->where('type',1)
                        ->where($day, 1)
                        //->where('date_end','>=',$date->toDateString())
                        ->where('recurrent_employes.id',$uno)
                        ->whereNull('employes.deleted_at')
                        ->groupBy('employes.name')
                        ->get(['employes.name as names', 'name_category','url_file as eurl_file','residence_id','check_in','employes.id as ide']);

                        if(empty($access) || is_null($access) || $access->isEmpty())
                        {
                            

                            $check_in = null;
                            $mensaje = 'No tiene acceso para el día de hoy.';
                            Session::flash('message', $mensaje ); 
                            return redirect()->action('DashboardGuardController@index');  
                        }
                        else
                        {

                            foreach ($access as $ac => $acces) {
                                $check = $acces->check_in;
                                $emp_id = $acces->ide;
                                $residence = $acces->residence_id;
                            }

                            if($check == 1)
                            {
                                $mensaje = 'Ya se registro la entrada de este empleado o proveedor.';
                                Session::flash('message', $mensaje );

                                $c = AccessColony::where('employe_id','=' ,$emp_id)->first();
                                $check_in = $c->check_in;
              
                            }
                            else
                            {
                                $check_in = null;
                            }
                        }     
                    }
                    elseif($tres == 3)
                    {
                        $access = RecurrentVisit::join('visits','visits.id','=','visit_id')
                        ->select('visits.name as namev','check_in','url_file as vurl_file','residence_id','visits.id as idv')
                        ->where('type',1)
                        ->where($day, 1)
                        ///->whereDate('date_end','>=',$date->toDateString())
                        ->where('recurrent_visits.id',$uno)
                        ->whereNull('visits.deleted_at')
                        ->get();

                        if(empty($access) || is_null($access) || $access->isEmpty())
                        {
                            
                            $check_in = null;
                            $mensaje = 'No tiene un acceso para el día de hoy.';
                            Session::flash('message', $mensaje ); 
                            return redirect()->action('DashboardGuardController@index');  
                        }
                        else
                        {

                            foreach ($access as $ac => $acces) {
                                $check = $acces->check_in;
                                $emp_id = $acces->ide;
                                $residence = $acces->residence_id;
                            }

                            if($check == 1)
                            {
                                $mensaje = 'Ya se registro la entrada de esta visita.';
                                Session::flash('message', $mensaje );

                                $c = AccessColony::where('visit_id','=' ,$emp_id)->first();
                             

                                $check_in = $c->check_in;
              
                            }
                            else
                            {
                                $check_in = null;
                            }
                        }

                    }
                    

                    $recurrente = 1;
                    
                }
                else
                {
                    // verificar que la fecha este en formato YYYY-MM-DD y sea válida,
                    if (preg_match ("/^([0-9]{4})-([0-9]{2})-([0-9]{2})$/", $cuatro, $parts))
                    {
                        if (checkdate($parts[2],$parts[3],$parts[1])) {
                             $f = 1;
                        } else {
                             $f = 2;
                        }
                    }
                    else
                    {
                        $f = 2;
                    }  


                    if($f == 1)
                    {

                        if($cuatro < $today)
                        {

                                $mensaje = 'Este QR ya expiro, el acceso era para la fecha: '.$cuatro.'.';
                                Session::flash('message', $mensaje );
                                return redirect()->action('DashboardGuardController@index');
                        }
                        elseif ($cuatro > $today) {



                                $mensaje = 'El acceso de esta visita es para la fecha: '.$cuatro.'.';
                                Session::flash('message', $mensaje );
                                return redirect()->action('DashboardGuardController@index'); 
                        }
                        else
                        {

                            $access = AccessColony::join('access_types','access_types.id','=','type')
                                ->leftjoin('employes', 'employe_id','=','employes.id')
                                ->leftjoin('employes_categories','category','=','employes_categories.id')
                                ->leftjoin('visits','visits.id','=','visit_id')
                                ->where('access_colonies.id',$uno)
                                ->where('access_colonies.date',$date->toDateString())
                                ->whereNull('check_out')
                                ->get(['employes.name as names','visits.name as namev','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','employes.id as ide','visits.id as idv','access_colonies.residence_id']);


                            
                            if(empty($access) || is_null($access) || $access->isEmpty())
                            {
                                
                                $check_in = null;
                                $mensaje = 'No tiene un acceso creado para el día de hoy.';
                                Session::flash('message', $mensaje );
                                return redirect()->action('DashboardGuardController@index');  
                            }
                            else
                            {
                                foreach ($access as $ac => $acces) {
                                    $check_in = $acces->check_in;
                                    $residence = $acces->residence_id;
                                }

                                if(!is_null($check_in))
                                {
                                    if($tres == 2)
                                    {
                                        $mensaje = 'Ya se registro la entrada de este empleado o proveedor.';
                                        Session::flash('message', $mensaje ); 
                                    }
                                    else
                                    {
                                        $mensaje = 'Ya se registro la entrada de esta visita.';
                                        Session::flash('message', $mensaje ); 
                                    }
                                     
                                        
                                }
                                else
                                {
                                    $check_in = null;
                                }
                            }

                            
                           
                            $recurrente = 2;
                        }
                    }
                    else
                    {
                        $access = AccessColony::join('access_types','access_types.id','=','type')
                                ->leftjoin('employes', 'employe_id','=','employes.id')
                                ->leftjoin('employes_categories','category','=','employes_categories.id')
                                ->leftjoin('visits','visits.id','=','visit_id')
                                ->where('access_colonies.id',$uno)
                                ->where('access_colonies.date',$date->toDateString())
                                ->whereNull('check_out')
                                ->get(['employes.name as names','visits.name as namev','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','employes.id as ide','visits.id as idv','access_colonies.residence_id']);


                            
                            if(empty($access) || is_null($access) || $access->isEmpty())
                            {
                                
                                $check_in = null;
                                $mensaje = 'No tiene un acceso creado para el día de hoy.';
                                Session::flash('message', $mensaje );
                                return redirect()->action('DashboardGuardController@index');  
                            }
                            else
                            {
                                foreach ($access as $ac => $acces) {
                                    $check_in = $acces->check_in;
                                    $residence = $acces->residence_id;
                                }

                                if(!is_null($check_in))
                                {
                                    if($tres == 2)
                                    {
                                        $mensaje = 'Ya se registro la entrada de este empleado o proveedor.';
                                        Session::flash('message', $mensaje ); 
                                    }
                                    else
                                    {
                                        $mensaje = 'Ya se registro la entrada de esta visita.';
                                        Session::flash('message', $mensaje ); 
                                    }
                                     
                                        
                                }
                                else
                                {
                                    $check_in = null;
                                }
                            }

                            
                           
                            $recurrente = 2;
                    }
                    
                }

                if($residence == 1)
                {
                     $scalle = "1";
                }
                else
                {
                    $scalle = "2";
                }
                
                $backsearchevent = "";
                $stregistro = "";
                $category = "";
                $category = EmployeCategory::all();
                $a = 0;
                $b = 0;
                $c = 0;
                $d = 0;
                $e = 0;
                $employe = "";
                $QRlook = 1;
                $photoback = $request->data;

                

                return view('QRreader.resultQR', compact('access','scalle','recurrente','tres','check_in','backsearchevent','stregistro','category','a','b','c','d','e','employe','QRlook','photoback'));
            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
              
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
              
        }
    
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return view('QRreader.resultQR');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        dd($id); 
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
