<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\AccessColony;
use App\Employe;
use App\AccessType;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use App\RecurrentEmploye;
use Session;

class RecurrentEmployeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
        try{

            $date = Carbon::now();
            $employe = Employe::findOrfail($request->id);
            $recurrent = RecurrentEmploye::where('employe_id',$employe->id)->first();
            $recurrent->update([

                'check_in' => 1,
            ]);
            $type = AccessType::where('name',"empleado")->first();


            AccessColony::create([
                'date' => $date->toDateString(),
                'residence_id' => $employe->residence_id,
                'employe_id' => $employe->id,
                'type'   => $type->id,
                'check_in' => $date,

            ]);

            if($request->qr)
            {
                $mensaje = "Se Se guardo la entrada correctamente.";
                Session::flash('message2', $mensaje );
                return redirect()->action('DashboardGuardController@index');
            }
            else
            {
                $street = $request->backsearch;
                return redirect()->action('DashboardGuardController@index', ['street' => $street]);
            }
             
            
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
