<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Income;
use App\Expense;
use App\Report;
use App\Month;
use App\Admin;
use App\ExpenseCategory;



class ReportResController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        if($request->category)
        {
            $expensecat = $request->category;
        }
        else
        {
            $expensecat = 1;
        }

        if($request->month)
        {
            $months = $request->month;
        }
        else
        {
            $actual_month = Admin::getActualMonth();
            $months = $actual_month->id;
        }

        if($request->category)
        {
            $expensecat = $request->category;
        }
        else
        {
            $expensecat = 1;
        }

        $incomepercentage = Report::getIncomesPercentage($months);
        $incomenumeral = Report::getIncomeNumeral($months);
        $incometotal = Admin::expectIncomes($months);
        $resident = Report::getNumberResidentPay($months);
        $residentpercent = Report::getPercentResidentPay($months);

        $expense = Report::getExpensePerMonth($months);

        $month = Month::all();


        $expensecategory = Report::getExpensePerCategory($months);
        $category = ExpenseCategory::all();
       

        return view('reports.res.index', compact('expensecategory','category','expensecat','incomepercentage','incomenumeral','incometotal','month','months','expense','resident','residentpercent','expense'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
