<?php

namespace App\Http\Controllers;

use App\Reservation;
use Illuminate\Http\Request;
use DB;
use App\SocialArea;
use App\PaymentType;
use App\Employe;
use App\Guest;
use App\Config;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Session;
use Carbon\Carbon;
use Auth;
use App\Street;
use App\Status;
use App\IncomeCategory;
use App\Admin;
use App\AccountReceivable;
use App\Payment;
use App\PaymentAccountReceivable;
use App\AccessColony;
use App\AccessType;
use App\Account;

class ReservationAdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        //Reservation::tiempoReserva();
        $user = Auth::user();
          
        if($user->can('index', \App\Reservation::class))
        {
            $status = Status::where('name',"pendiente")->first();
            $status2 = Status::where('name',"confirmar")->first();

            $reservation = DB::table('reservations')
                ->join('streets', 'residence_id', '=', 'streets.id')
                ->join('social_areas', 'social_areas.id', '=', 'social_area')
                ->join('status','reservation_status','=','status.id')
                ->leftjoin('payment_types', 'payment_type', '=', 'payment_types.id')
                ->select('reservations.*','reservations.id as idreserv', 'streets.name_street','streets.number','payment_types.payment_name', 'social_areas.*','status_name','status.name as namest','payment_types.id as ipayt')
                ->whereNull('reservations.deleted_at')
                ->where('reservation_status',$status->id)
                ->orWhere('reservation_status',$status2->id)
                ->paginate(15);

                
            $payment_type = PaymentType::all();
            $social_area = SocialArea::all();
            //$employe = Employe::where('user_id',Auth::id())->get();
            $m = Config::all();
            
            foreach ($m as $ms) 
            {
                $month = $ms->max_reservation_months;
            }

            $street = Street::getStreetwithUser();
            $day = date('w');
            if($day == 0)$actual_day = "sunday";
            if($day == 1)$actual_day = "monday";
            if($day == 2)$actual_day = "tuesday";
            if($day == 3)$actual_day = "wednesday";
            if($day == 4)$actual_day = "thursday";
            if($day == 5)$actual_day = "friday";
            if($day == 6)$actual_day = "saturday";
            $a = 0;
            $b = 1;
            $dt = Carbon::now();
            $dia = $dt->day;

            $account = Account::all();
            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }
            
            $LAsist = DB::table('social_areas')
                        ->pluck('limit_asist');

            return view('reservations.admin.index', compact('reservation','month','social_area','payment_type','street','a','actual_day','account','b','abierto','dia','LAsist'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        
        try{

            DB::beginTransaction();

            $messages = [
                'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                'max'   => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'file'        => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                'street'      =>  'required',
                'title'       =>  'required',
                'date'        =>  'required',
                'time_start'  =>  'required',
                'time_end'    =>  'required',
                'social_area' =>  'required',
            ];

            $validator = Validator::make($request->all(),$rules,$messages);
                

                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    
                    $area = SocialArea::findOrfail($request->social_area);
                    
                    //#Limite de casas y asistentes en area social
                    $CCasas = $area->cant_casas;
                    $CAforo = $area->limit_aforo;
                    $CAsist = $area->limit_asist;
                    
                    $FechaV = $request->date;
                    $SocialA = $request->social_area;
                    
                    $ECasas =  DB::table('reservations')
                        ->where('date','=',$FechaV)
                        ->where('social_area','=',$SocialA)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->count();
                        
                    $AforoT = DB::table('reservations')
                        ->where("date",'=',$FechaV)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->where("social_area",'=',$SocialA)
                        ->sum('cant_asist');
                        
                    $ResC = DB::table('reservations')
                        ->where('social_area','=',$SocialA)
                        ->where('residence_id','=',$request->street)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->where('date','=',$request->date)
                        ->count();
                    
                    
                    
                    
                    if($CAforo == 0){
                        $CASumt = 1;
                        $CAforo2 = 2;
                    }else{
                        $CAforo2 = $CAforo;
                        $CASumt = ($AforoT + $request->cant_asist)-1;
                    }
                    
                        
                    $CARest = ($CAforo2 - $AforoT);
                    //#Fin limite de casas y asistentes en area social
                    
                    //#Limite
                    $social_limits = DB::table('social_areas')
                        ->where('limit_event','=','1')
                        ->pluck('id');
                        
                    $fecha = $request->date;
                    $mes = substr($fecha, 0, 7);
                    
                    $eventos = DB::table('reservations')
                        ->where('residence_id', '=', $request->street)
                        ->where(function($query){
                            $query->where('reservation_status','=','1')->orWhere('reservation_status','=','3')->orWhere('reservation_status','=','7');
                        })
                        ->whereIn('social_area',$social_limits)
                        ->where("date", 'LIKE', '%'.$mes.'%')
                        ->count();
                    
                    $m = Config::all();
                    foreach ($m as $ms) 
                    {
                        $limits = $ms->limit_events;
                        $events = $ms->events_house;
                    }
                            
                    $limit = $area->limit_event;

                    //Datos para la validacion de la reserva
                    $maxMonth = DB::table('configs')
                        ->pluck('max_reservation_months');
                    $maxMonth = str_replace('[', '', $maxMonth);
                    $maxMonth = str_replace(']', '', $maxMonth);

                    $dateNow = Carbon::now();
                    $dateNow = $dateNow->format('Y-m-d');
                    $dateFinalNow =    \Carbon\Carbon::parse($dateNow)->endOfMonth()->toDateString();

                    $cant = $dateNow;
                    $dateLimit = \Carbon\Carbon::parse($cant)->addMonths($maxMonth);
                    $dateLimit = $dateLimit->format('Y-m-d');
                    $dateLimit = \Carbon\Carbon::parse($dateLimit)->endOfMonth()->toDateString();
                    $dateInput = $request->date;

                    if($maxMonth == "1"){
                        $date1 = $dateNow;
                        $date2 = $dateFinalNow;
                    }elseif($maxMonth > "1"){
                        $date1 = $dateNow;
                        $date2 = $dateLimit;
                    }

                    $dateInitial = \Carbon\Carbon::parse($dateNow)->startOfMonth()->toDateString();

                    if($dateInput >= $date1 && $dateInput <= $date2){
                        //#Limite de casas y asistentes en area social
                        if($ResC < 1){
                            if($ECasas < $CCasas){
                                if($AforoT < $CAforo || $CAforo == 0){
                                    if($CASumt < $CAforo2){
                                        if($limit == "1"){
                                            if($limits == "1"){
                                                if($eventos < $events){
                                                    if($area->cost == null || $area->cost == "0")
                                                    {
                                                        $status = Status::where('name','reservado')->first();
                                                        $payment_type = 1;
                                                    }
                                                    else
                                                    {
                                                        $status = Status::where('name','pendiente')->first();
                                                        $payment_type = $request->payment_type;
                                                    } 
                                
                                
                                                    $date = Carbon::now();
                                
                                                    $dias = $area->days_reserve_stay;
                                                    if(empty($dias) || is_null($dias))
                                                    {
                                                        $nuevafecha = null;
                                                    }
                                                    else
                                                    {
                                
                                                        $nuevafecha = strtotime ('+'.$dias.'day' , strtotime($date->toDateString()));
                                                        $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                                                    }
                                
                                
                                                    if (Input::hasFile('file'))
                                                    {
                                
                                                        $fileInput= Input::file('file');
                                                        $fileName = $fileInput->getClientOriginalName();
                                                        $path = public_path().'/uploads/vouchers/incomes/';
                                                        $url = '/uploads/vouchers/incomes/';
                                                        $fileType = $fileInput->getMimeType();
                                                        $fileSize = $fileInput->getClientSize()/1024;
                                
                                
                                                        if($fileInput->move($path,$fileName))
                                                        {       
                                                            $reservation = Reservation::create([
                                
                                                                'residence_id'       =>  $request->street,
                                                                'payment_type'       =>  $request->payment_type,
                                                                'title'              =>  $request->title,
                                                                'date'               =>  $request->date,
                                                                'time_start'         =>  $request->time_start,
                                                                'time_end'           =>  $request->time_end,
                                                                'color'              =>  $area->color,
                                                                'reservation_status' =>  $status->id,
                                                                'social_area'        =>  $request->social_area,
                                                                'voucher_name'       =>  $fileName,
                                                                'url_voucher'        =>  $url.$fileName,
                                                                'voucher_type'       =>  $fileType,
                                                                'voucher_size'       =>  $fileSize,
                                                                'limit_date'         =>  $nuevafecha,
                                                                'cant_asist'         =>  $request->cant_asist,
                                                            ]);
                                
                                                
                                                            $gt = count($request->guest);
                                                        
                                                            
                                
                                                            if($area->cost != null || $area->cost != "0")
                                                            {
                                                                /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                                $category = IncomeCategory::where('name','areas')->first();
                                                                $actual_month = Admin::getActualMonth();
                                                                $status = Status::where('name','activo')->first();
                                                                $account = AccountReceivable::create([
                                
                                                                    'category'  => $category->id,
                                                                    'debt'      => $area->cost,
                                                                    'to_pay'    => $area->cost,
                                                                    'month'     => $actual_month->id,
                                                                    'residence' => $request->street,
                                                                    'estatus'    => $status->id,
                                                                    'description' => $area->name_social_area."-".$request->date,
                                
                                                                ]);
                                
                                                                
                                
                                                                /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                            }
                                
                                                        }
                                
                                
                                                                
                                                    }
                                                    else
                                                    {
                                                        $reservation = Reservation::create([
                                
                                                            'residence_id'       => $request->street,
                                                            'payment_type'       => $request->payment_type,
                                                            'title'              => $request->title,
                                                            'date'               => $request->date,
                                                            'time_start'         => $request->time_start,
                                                            'time_end'           => $request->time_end,
                                                            'color'              => $area->color,
                                                            'reservation_status' => $status->id,
                                                            'social_area'        => $request->social_area,
                                                            'limit_date'         => $nuevafecha,
                                                            'cant_asist'         => $request->cant_asist,
                                                        ]);
                                
                                                        $gt = count($request->guest);
                                                        
                                                        if($gt == 1)
                                                        {
                                                            
                                                        }
                                                        else
                                                        {
                                                            $countAsist = ((count($request->guest)))-1;
                                                            if($request->cant_asist <= $CAsist){
                                                                for ($i=0; $i < (count($request->guest)); $i++)
                                                                {
                                                                    $guest = Guest::create([
                                    
                                                                        'name_guest'      => $request->guest[$i],
                                                                        'reservation_id'  => $reservation->id,
                                                                    ]);
                                    
                                    
                                                                    $access = AccessType::where('name','invitado')->first();
                                    
                                                                    AccessColony::create([
                                    
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => $request->street,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }else{
                                                                $conteo = (count($request->guest));
                                                                $conteo2 = $CAsist-1;
                                                                $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$conteo}."];
                                                                return redirect()->back()
                                                                    ->withErrors($errors);
                                                            }
                                                        }
                                
                                                            if($area->cost != null || $area->cost != "0")
                                                            {
                                
                                                                $category = IncomeCategory::where('name','areas')->first();
                                                                $actual_month = Admin::getActualMonth();
                                                                $status = Status::where('name','activo')->first();
                                                                $account = AccountReceivable::create([
                                
                                                                    'category'  => $category->id,
                                                                    'debt'      => $area->cost,
                                                                    'to_pay'    => $area->cost,
                                                                    'month'     => $actual_month->id,
                                                                    'residence' => $request->street,
                                                                    'deadline'  => $nuevafecha,
                                                                    'estatus'    => $status->id,
                                                                    'description' => $area->name_social_area."-".$request->date,
                                
                                                                ]);
                                                            }
                                                        
                                
                                                    }
                                                }else{
                                                    $errors = ['error' => 'Limite de reservaciones por mes alcanzado.'];
                                                    return redirect()->back()
                                                        ->withErrors($errors);
                                                }
                                            }else if($limits == "0"){
                                                if($area->cost == null || $area->cost == "0")
                                                {
                                                    $status = Status::where('name','reservado')->first();
                                                    $payment_type = 1;
                                                }
                                                else
                                                {
                                                    $status = Status::where('name','pendiente')->first();
                                                    $payment_type = $request->payment_type;
                                                } 
                            
                            
                                                $date = Carbon::now();
                            
                                                $dias = $area->days_reserve_stay;
                                                if(empty($dias) || is_null($dias))
                                                {
                                                    $nuevafecha = null;
                                                }
                                                else
                                                {
                            
                                                    $nuevafecha = strtotime ('+'.$dias.'day' , strtotime($date->toDateString()));
                                                    $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                                                }
                            
                            
                                                if (Input::hasFile('file'))
                                                {
                            
                                                    $fileInput= Input::file('file');
                                                    $fileName = $fileInput->getClientOriginalName();
                                                    $path = public_path().'/uploads/vouchers/incomes/';
                                                    $url = '/uploads/vouchers/incomes/';
                                                    $fileType = $fileInput->getMimeType();
                                                    $fileSize = $fileInput->getClientSize()/1024;
                            
                            
                                                    if($fileInput->move($path,$fileName))
                                                    {       
                                                        $reservation = Reservation::create([
                            
                                                            'residence_id'       =>  $request->street,
                                                            'payment_type'       =>  $request->payment_type,
                                                            'title'              =>  $request->title,
                                                            'date'               =>  $request->date,
                                                            'time_start'         =>  $request->time_start,
                                                            'time_end'           =>  $request->time_end,
                                                            'color'              =>  $area->color,
                                                            'reservation_status' =>  $status->id,
                                                            'social_area'        =>  $request->social_area,
                                                            'voucher_name'       =>  $fileName,
                                                            'url_voucher'        =>  $url.$fileName,
                                                            'voucher_type'       =>  $fileType,
                                                            'voucher_size'       =>  $fileSize,
                                                            'limit_date'         =>  $nuevafecha,
                                                            'cant_asist'         =>  $request->cant_asist,
                                                        ]);
                            
                                            
                                                        $gt = count($request->guest);
                                                    
                                                        if($gt == 1)
                                                        {
                                                            
                                                            for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                if(!empty($request->guest[$i]))
                                                                {
                                                                    $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                    ]);
                            
                                                                    $access = AccessType::where('name','invitado')->first();
                            
                                                                    AccessColony::create([
                            
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => $request->street,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }
                                                        }
                                                        else
                                                        {
                                                            for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                ]);
                            
                                                                $access = AccessType::where('name','invitado')->first();
                            
                                                                AccessColony::create([
                            
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => $request->street,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                            
                                                        if($area->cost != null || $area->cost != "0")
                                                        {
                                                            /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                            $category = IncomeCategory::where('name','areas')->first();
                                                            $actual_month = Admin::getActualMonth();
                                                            $status = Status::where('name','activo')->first();
                                                            $account = AccountReceivable::create([
                            
                                                                'category'  => $category->id,
                                                                'debt'      => $area->cost,
                                                                'to_pay'    => $area->cost,
                                                                'month'     => $actual_month->id,
                                                                'residence' => $request->street,
                                                                'estatus'    => $status->id,
                                                                'description' => $area->name_social_area."-".$request->date,
                            
                                                            ]);
                            
                                                            
                            
                                                            /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                        }
                            
                                                    }
                            
                            
                                                            
                                                }
                                                else
                                                {
                                                    $reservation = Reservation::create([
                            
                                                        'residence_id'       => $request->street,
                                                        'payment_type'       => $request->payment_type,
                                                        'title'              => $request->title,
                                                        'date'               => $request->date,
                                                        'time_start'         => $request->time_start,
                                                        'time_end'           => $request->time_end,
                                                        'color'              => $area->color,
                                                        'reservation_status' => $status->id,
                                                        'social_area'        => $request->social_area,
                                                        'limit_date'         => $nuevafecha,
                                                        'cant_asist'         => $request->cant_asist,
                                                    ]);
                            
                                                    $gt = count($request->guest);
                                                    
                                                    if($gt == 1)
                                                    {

                                                        for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                if(!empty($request->guest[$i]))
                                                                {
                                                                    $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                    ]);
                            
                                                                    $access = AccessType::where('name','invitado')->first();
                            
                                                                    AccessColony::create([
                            
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => $request->street,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }
                                                    }
                                                    else
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            $guest = Guest::create([
                            
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                            
                            
                                                            $access = AccessType::where('name','invitado')->first();
                            
                                                            AccessColony::create([
                            
                                                                'date'          => $request->date,
                                                                'residence_id'  => $request->street,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                            
                                                        if($area->cost != null || $area->cost != "0")
                                                        {
                            
                                                            $category = IncomeCategory::where('name','areas')->first();
                                                            $actual_month = Admin::getActualMonth();
                                                            $status = Status::where('name','activo')->first();
                                                            $account = AccountReceivable::create([
                            
                                                                'category'  => $category->id,
                                                                'debt'      => $area->cost,
                                                                'to_pay'    => $area->cost,
                                                                'month'     => $actual_month->id,
                                                                'residence' => $request->street,
                                                                'deadline'  => $nuevafecha,
                                                                'estatus'    => $status->id,
                                                                'description' => $area->name_social_area."-".$request->date,
                            
                                                            ]);
                                                        }
                                                    
                            
                                                }
                                            }
                                        }
                                        else if($limit == "0"){
                                            if($area->cost == null || $area->cost == "0")
                                            {
                                                $status = Status::where('name','reservado')->first();
                                                $payment_type = 1;
                                            }
                                            else
                                            {
                                                $status = Status::where('name','pendiente')->first();
                                                $payment_type = $request->payment_type;
                                            } 
                        
                        
                                            $date = Carbon::now();
                        
                                            $dias = $area->days_reserve_stay;
                                            if(empty($dias) || is_null($dias))
                                            {
                                                $nuevafecha = null;
                                            }
                                            else
                                            {
                        
                                                $nuevafecha = strtotime ('+'.$dias.'day' , strtotime($date->toDateString()));
                                                $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                                            }
                        
                        
                                            if (Input::hasFile('file'))
                                            {
                        
                                                $fileInput= Input::file('file');
                                                $fileName = $fileInput->getClientOriginalName();
                                                $path = public_path().'/uploads/vouchers/incomes/';
                                                $url = '/uploads/vouchers/incomes/';
                                                $fileType = $fileInput->getMimeType();
                                                $fileSize = $fileInput->getClientSize()/1024;
                        
                        
                                                if($fileInput->move($path,$fileName))
                                                {       
                                                    $reservation = Reservation::create([
                        
                                                        'residence_id'       =>  $request->street,
                                                        'payment_type'       =>  $request->payment_type,
                                                        'title'              =>  $request->title,
                                                        'date'               =>  $request->date,
                                                        'time_start'         =>  $request->time_start,
                                                        'time_end'           =>  $request->time_end,
                                                        'color'              =>  $area->color,
                                                        'reservation_status' =>  $status->id,
                                                        'social_area'        =>  $request->social_area,
                                                        'voucher_name'       =>  $fileName,
                                                        'url_voucher'        =>  $url.$fileName,
                                                        'voucher_type'       =>  $fileType,
                                                        'voucher_size'       =>  $fileSize,
                                                        'limit_date'         =>  $nuevafecha,
                                                        'cant_asist'         =>  $request->cant_asist,
                                                    ]);
                        
                                        
                                                    $gt = count($request->guest);
                                                
                                                    if($gt == 1)
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            if(!empty($request->guest[$i]))
                                                            {
                                                                $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                                ]);
                        
                                                                $access = AccessType::where('name','invitado')->first();
                        
                                                                AccessColony::create([
                        
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => $request->street,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                                                    }
                                                    else
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                        
                                                            $access = AccessType::where('name','invitado')->first();
                        
                                                            AccessColony::create([
                        
                                                                'date'          => $request->date,
                                                                'residence_id'  => $request->street,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                        
                                                    if($area->cost != null || $area->cost != "0")
                                                    {
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                        $category = IncomeCategory::where('name','areas')->first();
                                                        $actual_month = Admin::getActualMonth();
                                                        $status = Status::where('name','activo')->first();
                                                        $account = AccountReceivable::create([
                        
                                                            'category'  => $category->id,
                                                            'debt'      => $area->cost,
                                                            'to_pay'    => $area->cost,
                                                            'month'     => $actual_month->id,
                                                            'residence' => $request->street,
                                                            'estatus'    => $status->id,
                                                            'description' => $area->name_social_area."-".$request->date,
                        
                                                        ]);
                        
                                                        
                        
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                    }
                        
                                                }
                        
                        
                                                        
                                            }
                                            else
                                            {
                                                $reservation = Reservation::create([
                        
                                                    'residence_id'       => $request->street,
                                                    'payment_type'       => $request->payment_type,
                                                    'title'              => $request->title,
                                                    'date'               => $request->date,
                                                    'time_start'         => $request->time_start,
                                                    'time_end'           => $request->time_end,
                                                    'color'              => $area->color,
                                                    'reservation_status' => $status->id,
                                                    'social_area'        => $request->social_area,
                                                    'limit_date'         => $nuevafecha,
                                                    'cant_asist'         => $request->cant_asist,
                                                ]);
                        
                                                $gt = count($request->guest);
                                                
                                                if($gt == 1)
                                                {
                                                    //#AquiSi
                                                    if($request->cant_asist <= $CAsist){
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            if(!empty($request->guest[$i]))
                                                            if(!empty($request->guest[$i]))
                                                            {
                                                                $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                                ]);
                        
                                                                $access = AccessType::where('name','invitado')->first();
                        
                                                                AccessColony::create([
                        
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => Auth::user()->street_id,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                                                    }else{
                                                        $conteo = (count($request->guest));
                                                        $conteo2 = $CAsist-1;
                                                        $cantidad = $request->cant_asist;
                                                        $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                        return redirect()->back()
                                                            ->withErrors($errors);
                                                    }
                                                }
                                                else
                                                {
                                                    //#AquiSi
                                                    $countAsist = ((count($request->guest)))-1;
                                                    if($request->cant_asist <= $CAsist){
                                                        for ($i=0; $i < (count($request->guest)); $i++)
                                                        {
                                                            $guest = Guest::create([
                            
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                            
                            
                                                            $access = AccessType::where('name','invitado')->first();
                                                            
                                                            AccessColony::create([
                            
                                                                'date'          => $request->date,
                                                                'residence_id'  => $request->street,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }else{
                                                        $conteo = (count($request->guest));
                                                        $conteo2 = $CAsist-1;
                                                        $cantidad = $request->cant_asist;
                                                        $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                        return redirect()->back()
                                                            ->withErrors($errors);
                                                    }
                                                }
                        
                                                    if($area->cost != null || $area->cost != "0")
                                                    {
                        
                                                        $category = IncomeCategory::where('name','areas')->first();
                                                        $actual_month = Admin::getActualMonth();
                                                        $status = Status::where('name','activo')->first();
                                                        $account = AccountReceivable::create([
                        
                                                            'category'  => $category->id,
                                                            'debt'      => $area->cost,
                                                            'to_pay'    => $area->cost,
                                                            'month'     => $actual_month->id,
                                                            'residence' => $request->street,
                                                            'deadline'  => $nuevafecha,
                                                            'estatus'    => $status->id,
                                                            'description' => $area->name_social_area."-".$request->date,
                        
                                                        ]);
                                                    }
                                                
                        
                                            }
                                        }
                                        //#Fin limite
                                    }else{
                                        $errors = ['error' => "Esta area social actualmente tiene disponible solo {$CARest} lugares, asegurate que tu cantidad de asistentes no sobre pase la cantidad disponible({$CARest}) y la cantidad por residencia({$CAsist})."];
                                        return redirect()->back()
                                            ->withErrors($errors);
                                    }
                                }else{
                                    $errors = ['error' => "Esta area social actualmente tiene disponible solo {$CARest} lugares, asegurate que tu cantidad de asistentes no sobre pase la cantidad disponible({$CARest}) y la cantidad por residencia({$CAsist})."];
                                    return redirect()->back()
                                        ->withErrors($errors);
                                }
                            }else{
                                $errors = ['error' => "El area social seleccionada ya esta en su limite de reservas para la fecha {$FechaV}.    El limite de casas que pueden reservar a la vez: {$CCasas}. "];
                                return redirect()->back()
                                    ->withErrors($errors);
                            }
                        }else{
                            $errors = ['error' => "Ya tienes una reserva en esta area social el {$FechaV}."];
                            return redirect()->back()
                                ->withErrors($errors);
                        } 
                    }else{
                        $errors = ['error' => "Las reservas solo se pueden hacer entre {$dateInitial} - {$date2}"];
                        return redirect()->back()
                            ->withErrors($errors);
                    }  
                    
                    
                    /*if($area->cost == null || $area->cost == "0")
                    {
                        $status = Status::where('name','reservado')->first();
                        $payment_type = 1;
                    }
                    else
                    {
                        $status = Status::where('name','pendiente')->first();
                        $payment_type = $request->payment_type;
                    } 


                    $date = Carbon::now();

                    $dias = $area->days_reserve_stay;
                    if(empty($dias) || is_null($dias))
                    {
                        $nuevafecha = null;
                    }
                    else
                    {

                        $nuevafecha = strtotime ('+'.$dias.'day' , strtotime($date->toDateString()));
                        $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                    }


                    if (Input::hasFile('file'))
                    {

                        $fileInput= Input::file('file');
                        $fileName = $fileInput->getClientOriginalName();
                        $path = public_path().'/uploads/vouchers/incomes/';
                        $url = '/uploads/vouchers/incomes/';
                        $fileType = $fileInput->getMimeType();
                        $fileSize = $fileInput->getClientSize()/1024;


                        if($fileInput->move($path,$fileName))
                        {       
                            $reservation = Reservation::create([

                                'residence_id'       =>  $request->street,
                                'payment_type'       =>  $request->payment_type,
                                'title'              =>  $request->title,
                                'date'               =>  $request->date,
                                'time_start'         =>  $request->time_start,
                                'time_end'           =>  $request->time_end,
                                'color'              =>  $area->color,
                                'reservation_status' =>  $status->id,
                                'social_area'        =>  $request->social_area,
                                'voucher_name'       =>  $fileName,
                                'url_voucher'        =>  $url.$fileName,
                                'voucher_type'       =>  $fileType,
                                'voucher_size'       =>  $fileSize,
                                'limit_date'         =>  $nuevafecha,
                            ]);

                
                            $gt = count($request->guest);
                        
                            if($gt == 1)
                            {
                                for ($i=0; $i < count($request->guest); $i++)
                                {
                                    if(!empty($request->guest[$i]))
                                    {
                                        $guest = Guest::create([

                                        'name_guest'      => $request->guest[$i],
                                        'reservation_id'  => $reservation->id,
                                        ]);

                                        $access = AccessType::where('name','invitado')->first();

                                        AccessColony::create([

                                            'date'          => $request->date,
                                            'residence_id'  => $request->street,
                                            'event_id'      => $reservation->id,
                                            'guest_id'      => $guest->id,
                                            'type'          => $access->id,
                                        ]);
                                    }
                                }
                            }
                            else
                            {
                                for ($i=0; $i < count($request->guest); $i++)
                                {
                                    $guest = Guest::create([

                                        'name_guest'      => $request->guest[$i],
                                        'reservation_id'  => $reservation->id,
                                    ]);

                                    $access = AccessType::where('name','invitado')->first();

                                    AccessColony::create([

                                        'date'          => $request->date,
                                        'residence_id'  => $request->street,
                                        'event_id'      => $reservation->id,
                                        'guest_id'      => $guest->id,
                                        'type'          => $access->id,
                                    ]);
                                }
                            }

                            if($area->cost != null || $area->cost != "0")
                            {
                                /*** GENERAR PAGO DE CUOTA DE AREA 
                                $category = IncomeCategory::where('name','areas')->first();
                                $actual_month = Admin::getActualMonth();
                                $status = Status::where('name','activo')->first();
                                $account = AccountReceivable::create([

                                    'category'  => $category->id,
                                    'debt'      => $area->cost,
                                    'to_pay'    => $area->cost,
                                    'month'     => $actual_month->id,
                                    'residence' => $request->street,
                                    'estatus'    => $status->id,
                                    'description' => $area->name_social_area."-".$request->date,

                                ]);

                                

                                /*** GENERAR PAGO DE CUOTA DE AREA 
                            }

                        }


                                
                    }
                    else
                    {
                        $reservation = Reservation::create([

                            'residence_id'       => $request->street,
                            'payment_type'       => $request->payment_type,
                            'title'              => $request->title,
                            'date'               => $request->date,
                            'time_start'         => $request->time_start,
                            'time_end'           => $request->time_end,
                            'color'              => $area->color,
                            'reservation_status' => $status->id,
                            'social_area'        => $request->social_area,
                            'limit_date'         => $nuevafecha,
                        ]);

                        $gt = count($request->guest);
                        
                        if($gt == 1)
                        {
                            for ($i=0; $i < count($request->guest); $i++)
                                {
                                    if(!empty($request->guest[$i]))
                                    {
                                        $guest = Guest::create([

                                        'name_guest'      => $request->guest[$i],
                                        'reservation_id'  => $reservation->id,
                                        ]);

                                        $access = AccessType::where('name','invitado')->first();

                                        AccessColony::create([

                                            'date'          => $request->date,
                                            'residence_id'  => $request->street,
                                            'event_id'      => $reservation->id,
                                            'guest_id'      => $guest->id,
                                            'type'          => $access->id,
                                        ]);
                                    }
                                }
                        }
                        else
                        {
                            for ($i=0; $i < count($request->guest); $i++)
                            {
                                $guest = Guest::create([

                                    'name_guest'      => $request->guest[$i],
                                    'reservation_id'  => $reservation->id,
                                ]);


                                $access = AccessType::where('name','invitado')->first();

                                AccessColony::create([

                                    'date'          => $request->date,
                                    'residence_id'  => $request->street,
                                    'event_id'      => $reservation->id,
                                    'guest_id'      => $guest->id,
                                    'type'          => $access->id,
                                ]);
                            }
                        }

                            if($area->cost != null || $area->cost != "0")
                            {

                                $category = IncomeCategory::where('name','areas')->first();
                                $actual_month = Admin::getActualMonth();
                                $status = Status::where('name','activo')->first();
                                $account = AccountReceivable::create([

                                    'category'  => $category->id,
                                    'debt'      => $area->cost,
                                    'to_pay'    => $area->cost,
                                    'month'     => $actual_month->id,
                                    'residence' => $request->street,
                                    'deadline'  => $nuevafecha,
                                    'estatus'    => $status->id,
                                    'description' => $area->name_social_area."-".$request->date,

                                ]);
                            }
                        

                    }*/
                }

            DB::commit();

            
            return redirect()->action('ReservationAdminController@index', ['abierto' => "1"]);

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
           
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
            
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function show(Reservation $reservation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function edit(Reservation $reservation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Reservation $reservation)
    {
        
       try{

            DB::beginTransaction();

                $fecha = Carbon::now();
                $status   = Status::where('name','reservado')->first();
                $reserva  = Reservation::findOrfail($request->id);
                $area     = SocialArea::findOrfail($reserva->social_area);
                $actual_month = Admin::getActualMonth();

                if(empty($request->paytipo) || is_null($request->paytipo))
                {
                    $pago = $reserva->payment_type;
                }
                else
                {
                    $pago = $request->paytipo;
                }

                $reserva->update([

                    'reservation_status' => $status->id,

                ]);

                $status2 = Status::where('name','aprobado')->first();

                if(is_null($reserva->url_file))
                {
                    $pay = Payment::create([
                                
                        'amount'        => $area->cost,
                        'description'   => "Cuota área social",
                        'residence'     => $reserva->residence_id,
                        'capture_date'  => $fecha->toDateString(),
                        'payment_date'  => $fecha->toDateString(),
                        'payment_type'  => $pago,
                        'month'         => $actual_month->id,
                        'status'        => $status2->id,

                    ]);
                }
                else
                {
                    $pay = Payment::create([
                                
                        'amount'        => $area->cost,
                        'description'   => "Cuota área social",
                        'residence'     => $reserva->residence_id,
                        'capture_date'  => $fecha->toDateString(),
                        'payment_date'  => $fecha->toDateString(),
                        'payment_type'  => $pago,
                        'name_file'     => $reserva->voucher_name,
                        'url_file'      => $reserva->url_voucher,
                        'type_file'     => $reserva->voucher_type,
                        'size_file'     => $reserva->voucher_size,
                        'month'         => $actual_month->id,
                        'status'        => $status2->id,

                    ]);
                }

                $category = IncomeCategory::where('name','areas')->first();
                $account = AccountReceivable::where('residence',$reserva->residence_id)->where('to_pay',$area->cost)->where('category',$category->id)->first();
                $status = Status::where('name','pagado')->first();
                $deuda = $account->to_pay;
                $account->update([

                    'to_pay' => 0,
                    'estatus' => $status->id,
                ]);

                $payment = PaymentAccountReceivable::create([

                    'id_payment'               => $pay->id,
                    'id_account_receivables'   => $account->id,
                    'paid'                     => $area->cost,
                    'new_debt'                 => 0,
                    'old_debt'                 => $deuda,
                ]); 

                $account = Account::findOrfail($request->account);
                $balance = $account->balance + $area->cost;
                $account->update([

                    'balance' => $balance,

                ]);

            DB::commit();

            return redirect('/reservations');

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Reservation $reservation, Request $request)
    {
       try{

            DB::beginTransaction();

                    $status = Status::where('name',"cancelado")->first();

                    $reserva = Reservation::findOrfail($request->id);
                    $area     = SocialArea::findOrfail($reserva->social_area);
                    $category = IncomeCategory::where('name','areas')->first();

                    $reserva->update([

                        'reservation_status' => $status->id,
                    ]);

                    $account = AccountReceivable::where('residence',$reserva->residence_id)->where('to_pay',$area->cost)->where('category',$category->id)->first();

                    if(empty($account))
                    {

                    }
                    else
                    {
                        $account->update([

                            'estatus' => $status->id,
                        ]);
                        
                        $account->delete();
                    }

                    $guest = AccessColony::where('event_id',$reserva->id);
                    $guest->delete();
                    

            DB::commit();
        
            return redirect('/reservations');


        } catch (\Illuminate\Database\QueryException $e) {
             
        $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
          
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              
        }
    }
}
