<?php

namespace App\Http\Controllers;

use App\Reservation;
use Illuminate\Http\Request;
use Auth;
use App\SocialArea;
use App\PaymentType;
use App\Employe;
use App\Guest;
use App\Config;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Session;
use Carbon\Carbon;
use DB;
use App\Status;
use App\AccessType;
use App\AccessColony;
use App\IncomeCategory;
use App\AccountReceivable;
use App\Admin;


class ReservationResController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $user = Auth::user();
          
        if($user->can('index', \App\ReservationRes::class))
        {
            $permission = Config::permissionDebtors();
            if($permission == 1)
            {
                $payment_type = PaymentType::all();
                $social_area = SocialArea::all();
                
                $m= Config::all();
                
                foreach ($m as $ms) 
                {
                    $month = $ms->max_reservation_months;
                }
                
                $user = Auth::user();
                $reservation_active = $user->reservation_permission;

                 $day = date('w');
                if($day == 0)$actual_day = "sunday";
                if($day == 1)$actual_day = "monday";
                if($day == 2)$actual_day = "tuesday";
                if($day == 3)$actual_day = "wednesday";
                if($day == 4)$actual_day = "thursday";
                if($day == 5)$actual_day = "friday";
                if($day == 6)$actual_day = "saturday";

                if($request->abierto == 1)
                {
                     $abierto = 1;
                }
                else
                {
                     $abierto = 0;
                }

                $dt = Carbon::now();
                $dia = $dt->day;

                $maxMonth = DB::table('configs')
                    ->pluck('max_reservation_months');
                $maxMonth = str_replace('[', '', $maxMonth);
                $maxMonth = str_replace(']', '', $maxMonth);
                $maxMonth2 = $maxMonth -1;

                $dateNow = Carbon::now();
                $dateNow = $dateNow->format('Y-m-d');

                if($maxMonth > 1){
                    $cant = $dateNow;
                    $dateLimit = \Carbon\Carbon::parse($cant)->addMonths($maxMonth2);
                    $dateLimit = $dateLimit->format('Y-m-d');
                    $dateLimit = \Carbon\Carbon::parse($dateLimit)->endOfMonth()->toDateString();
                }elseif($maxMonth == 1){
                    $cant = $dateNow;
                    $dateLimit = \Carbon\Carbon::parse($cant);
                    $dateLimit = $dateLimit->format('Y-m-d');
                    $dateLimit = \Carbon\Carbon::parse($dateLimit)->endOfMonth()->toDateString();
                }

                return view('reservations.resident.index', compact('social_area','payment_type','month','reservation_active','actual_day','abierto','dia','dateLimit'));
            }
            else
            {
                return redirect('/home');
            }
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
          //dd($request->all());
          try{

            DB::beginTransaction();

            
                $messages = [

                    'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'   => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                    'required'  => 'Este campo es requerido.',
                ];

                $rules = [

                    'file'          =>  'max:5000|mimes:jpeg,jpg,png,pdf',
                    'title'         =>  'required',
                    'date'          =>  'required',
                    'time_start'    =>  'required',
                    'time_end'      =>  'required',
                    'social_area'   =>  'required',
                ];


                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    
                    $area = SocialArea::findOrfail($request->social_area);
                    
                    //#Limite de casas y asistentes en area social
                    $CCasas = $area->cant_casas;
                    $CAfore = $area->limit_aforo;
                    $CAsist = $area->limit_asist;
                    
                    $FechaV = $request->date;
                    $SocialA = $request->social_area;
                    
                    $ECasas =  DB::table('reservations')
                        ->where('date','=',$FechaV)
                        ->where('social_area','=',$SocialA)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->count();
                        
                    $AforeT = DB::table('reservations')
                        ->where("date",'=',$FechaV)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->where("social_area",'=',$SocialA)
                        ->sum('cant_asist');
                        
                    $ResC = DB::table('reservations')
                        ->where('social_area','=',$SocialA)
                        ->where('residence_id','=',Auth::user()->street_id)
                        ->where(function($query){
                            $query->where('reservation_status','!=','6')->Where('reservation_status','!=','5');
                        })
                        ->where('date','=',$request->date)
                        ->count();
                    
                    if($CAfore == 0){
                        $CASumt = 1;
                        $CAfore2 = 2;
                    }else{
                        $CAfore2 = $CAfore;
                        $CASumt = ($AforeT + $request->cant_asist)-1;
                    }
                        
                    $CARest = ($CAfore2 - $AforeT);
                    //#Fin limite de casas y asistentes en area social
                        
                    //#Limite de eventos
                    $social_limits = DB::table('social_areas')
                        ->where('limit_event','=','1')
                        ->pluck('id');
                        
                    $fecha = $request->date;
                    $mes = substr($fecha, 0, 7);
                    
                    $eventos = DB::table('reservations')
                        ->where('residence_id', '=', Auth::user()->street_id)
                        ->where(function($query){
                            $query->where('reservation_status','=','1')->orWhere('reservation_status','=','3')->orWhere('reservation_status','=','7');
                        })
                        ->whereIn('social_area',$social_limits)
                        ->where("date", 'LIKE', '%'.$mes.'%')
                        ->count();
                    
                    $m = Config::all();
                    foreach ($m as $ms) 
                    {
                        $limits = $ms->limit_events;
                        $events = $ms->events_house;
                    }
                        
                    $limit = $area->limit_event;

                    //Datos para la validacion de la reserva
                    $maxMonth = DB::table('configs')
                        ->pluck('max_reservation_months');
                    $maxMonth = str_replace('[', '', $maxMonth);
                    $maxMonth = str_replace(']', '', $maxMonth);
                    $maxMonth2 = $maxMonth -1;

                    $dateNow = Carbon::now();
                    $dateNow = $dateNow->format('Y-m-d');
                    $dateFinalNow =    \Carbon\Carbon::parse($dateNow)->endOfMonth()->toDateString();

                    if($maxMonth > 1){
                        $cant = $dateNow;
                        $dateLimit = \Carbon\Carbon::parse($cant)->addMonths($maxMonth2);
                        $dateLimit = $dateLimit->format('Y-m-d');
                        $dateLimit = \Carbon\Carbon::parse($dateLimit)->endOfMonth()->toDateString();
                    }elseif($maxMonth == 1){
                        $cant = $dateNow;
                        $dateLimit = \Carbon\Carbon::parse($cant);
                        $dateLimit = $dateLimit->format('Y-m-d');
                        $dateLimit = \Carbon\Carbon::parse($dateLimit)->endOfMonth()->toDateString();
                    }

                    $dateInput = $request->date;

                    if($maxMonth == "1"){
                        $date1 = $dateNow;
                        $date2 = $dateFinalNow;
                    }elseif($maxMonth > "1"){
                        $date1 = $dateNow;
                        $date2 = $dateLimit;
                    }

                    $dateInitial = \Carbon\Carbon::parse($dateNow)->startOfMonth()->toDateString();
                    
                    if($dateInput >= $date1 && $dateInput <= $date2){
                        //#Limite de casas y asistentes en area social
                        if($ResC < 1){
                            if($ECasas < $CCasas){
                                if($AforeT < $CAfore || $CAfore == 0){
                                    if($CASumt < $CAfore2){
                                        if($limit == "1"){
                                            if($limits == "1"){
                                                if($eventos < $events){
                                                    if($area->cost == null || $area->cost == "0")
                                                    {
                                                        $status = Status::where('name','reservado')->first();
                                                        $payment_type = 1;
                                                    }
                                                    else
                                                    {
                                                        $status = Status::where('name','pendiente')->first();
                                                        $payment_type = $request->payment_type;
                                                    } 
                                                    
                                                    $date = Carbon::now();
                                                    $dias = $area->days_reserve_stay;
                                                    $nuevafecha = strtotime ('+'.$dias.'day' , strtotime( $date->toDateString()));
                                                    $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                                                    
                                                    if (Input::hasFile('file'))
                                                    {
                                                        $fileInput= Input::file('file');
                                                        $fileName = $fileInput->getClientOriginalName();
                                                        $path = public_path().'/uploads/vouchers/incomes/';
                                                        $url = '/uploads/vouchers/incomes/';
                                                        $fileType = $fileInput->getMimeType();
                                                        $fileSize = $fileInput->getClientSize()/1024;
                                
                                
                                                        if($fileInput->move($path,$fileName))
                                                        {       
                                                            $reservation = Reservation::create([
                                
                                                                'residence_id'       =>  Auth::user()->street_id,
                                                                'payment_type'       =>  $request->payment_type,
                                                                'title'              =>  $request->title,
                                                                'date'               =>  $request->date,
                                                                'time_start'         =>  $request->time_start,
                                                                'time_end'           =>  $request->time_end,
                                                                'color'              =>  $area->color,
                                                                'reservation_status' =>  $status->id,
                                                                'social_area'        =>  $request->social_area,
                                                                'voucher_name'       =>  $fileName,
                                                                'url_voucher'        =>  $url.$fileName,
                                                                'voucher_type'       =>  $fileType,
                                                                'voucher_size'       =>  $fileSize,
                                                                'limit_date'         =>  $nuevafecha,
                                                                //'cant_asist'         =>  $request->cant_asist,
                                
                                                            ]);
                                
                                                            
                                                            $c = count($request->guest);
                                                            if($c == 1 )
                                                            {
                                                                for ($i=0; $i < count($request->guest); $i++)
                                                                {
                                                                    if(!empty($request->guest[$i]))
                                                                    {
                                                                        $guest = Guest::create([
                                
                                                                        'name_guest'      => $request->guest[$i],
                                                                        'reservation_id'  => $reservation->id,
                                                                        ]);
                                
                                                                        $access = AccessType::where('name','invitado')->first();
                                
                                                                        AccessColony::create([
                                
                                                                            'date'          => $request->date,
                                                                            'residence_id'  => Auth::user()->street_id,
                                                                            'event_id'      => $reservation->id,
                                                                            'guest_id'      => $guest->id,
                                                                            'type'          => $access->id,
                                                                        ]);
                                                                    }
                                                                }
                                                            }
                                                            else
                                                            {
                                                                for ($i=0; $i < count($request->guest); $i++)
                                                                {
                                                                    if(!empty($request->guest[$i]))
                                                                    
                                                                    $guest = Guest::create([
                                
                                                                        'name_guest'      => $request->guest[$i],
                                                                        'reservation_id'  => $reservation->id,
                                                                    ]);
                                
                                                                    $access = AccessType::where('name','invitado')->first();
                                
                                                                    AccessColony::create([
                                
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => Auth::user()->street_id,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }
                                
                                                            if($area->cost != null || $area->cost != "0")
                                                            {
                                
                                                                /*** GENERAR PAGO DE CUOTA DE AREA ***/
                                                                    $category = IncomeCategory::where('name','areas')->first();
                                                                    $actual_month = Admin::getActualMonth();
                                                                    $status = Status::where('name','activo')->first();
                                                                    $account = AccountReceivable::create([
                                
                                                                        'category'  => $category->id,
                                                                        'debt'      => $area->cost,
                                                                        'to_pay'    => $area->cost,
                                                                        'month'     => $actual_month->id,
                                                                        'residence' => Auth::user()->street_id,
                                                                        'estatus'    => $status->id,
                                                                        'description' => $area->name_social_area."-".$request->date,
                                
                                                                    ]);
                                                                /*** GENERAR PAGO DE CUOTA DE AREA ***/
                                                            }
                                                            
                                                        }
                                                                
                                                    }
                                                    else
                                                    {
                                                        $reservation = Reservation::create([
                                
                                                            'residence_id'       => Auth::user()->street_id,
                                                            'payment_type'       => $request->payment_type,
                                                            'title'              => $request->title,
                                                            'date'               => $request->date,
                                                            'time_start'         => $request->time_start,
                                                            'time_end'           => $request->time_end,
                                                            'color'              => $area->color,
                                                            'reservation_status' => $status->id,
                                                            'social_area'        => $request->social_area,
                                                            'limit_date'         => $nuevafecha,
                                                            //'cant_asist'         =>  $request->cant_asist,
                                                        ]);
                                
                                                        $c = count($request->guest);
                                                        //#Aqui
                                                        if($c == 1 )
                                                        {
                                                            //if($request->cant_asist <= $CAsist){
                                                                for ($i=0; $i < count($request->guest); $i++)
                                                                {
                                                                    if(!empty($request->guest[$i]))
                                                                    if(!empty($request->guest[$i]))
                                                                    {
                                                                        $guest = Guest::create([
                                
                                                                        'name_guest'      => $request->guest[$i],
                                                                        'reservation_id'  => $reservation->id,
                                                                        ]);
                                
                                                                        $access = AccessType::where('name','invitado')->first();
                                
                                                                        AccessColony::create([
                                
                                                                            'date'          => $request->date,
                                                                            'residence_id'  => Auth::user()->street_id,
                                                                            'event_id'      => $reservation->id,
                                                                            'guest_id'      => $guest->id,
                                                                            'type'          => $access->id,
                                                                        ]);
                                                                    }
                                                                }
                                                            /*}else{
                                                                $conteo = (count($request->guest));
                                                                $conteo2 = $CAsist-1;
                                                                $cantidad = $request->cant_asist;
                                                                $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                                return redirect()->back()
                                                                    ->withErrors($errors);
                                                            }*/
                                                        }
                                                        else
                                                        {
                                                            //#Aqui
                                                            //if($request->cant_asist <= $CAsist){
                                                                for ($i=0; $i < count($request->guest); $i++)
                                                                {
                                                                    if(!empty($request->guest[$i]))
                                                                    $guest = Guest::create([
                                    
                                                                        'name_guest'      => $request->guest[$i],
                                                                        'reservation_id'  => $reservation->id,
                                                                    ]);
                                    
                                    
                                                                    $access = AccessType::where('name','invitado')->first();
                                    
                                                                    AccessColony::create([
                                    
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => Auth::user()->street_id,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            /*}
                                                            else{
                                                                $conteo = (count($request->guest));
                                                                $conteo2 = $CAsist-1;
                                                                $cantidad = $request->cant_asist;
                                                                $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                                return redirect()->back()
                                                                    ->withErrors($errors);
                                                            }*/
                                                                
                                                        }
                                
                                                        if($area->cost != null || $area->cost != "0")
                                                        {
                                
                                                            /*** GENERAR PAGO DE CUOTA DE AREA ***/
                                                                $category = IncomeCategory::where('name','areas')->first();
                                                                $actual_month = Admin::getActualMonth();
                                                                $status = Status::where('name','activo')->first();
                                                                $account = AccountReceivable::create([
                                
                                                                    'category'  => $category->id,
                                                                    'debt'      => $area->cost,
                                                                    'to_pay'    => $area->cost,
                                                                    'month'     => $actual_month->id,
                                                                    'residence' => Auth::user()->street_id,
                                                                    'deadline'  => $nuevafecha,
                                                                    'estatus'    => $status->id,
                                                                    'description' => $area->name_social_area."-".$request->date,
                                
                                                                ]);
                                                            /*** GENERAR PAGO DE CUOTA DE AREA ***/
                                                        }
                                
                                                    }
                                                }else{
                                                    $errors = ['error' => 'Limite de reservaciones por mes alcanzado.'];
                                                    return redirect()->back()
                                                        ->withErrors($errors);
                                                }
                                            }else if($limits == "0"){
                                                if($area->cost == null || $area->cost == "0")
                                                {
                                                    $status = Status::where('name','reservado')->first();
                                                    $payment_type = 1;
                                                }
                                                else
                                                {
                                                    $status = Status::where('name','pendiente')->first();
                                                    $payment_type = $request->payment_type;
                                                } 
                                                
                                                $date = Carbon::now();
                                                $dias = $area->days_reserve_stay;
                                                $nuevafecha = strtotime ('+'.$dias.'day' , strtotime( $date->toDateString()));
                                                $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                            
                            
                                                if (Input::hasFile('file'))
                                                {
                            
                                                    $fileInput= Input::file('file');
                                                    $fileName = $fileInput->getClientOriginalName();
                                                    $path = public_path().'/uploads/vouchers/incomes/';
                                                    $url = '/uploads/vouchers/incomes/';
                                                    $fileType = $fileInput->getMimeType();
                                                    $fileSize = $fileInput->getClientSize()/1024;
                            
                            
                                                    if($fileInput->move($path,$fileName))
                                                    {       
                                                        $reservation = Reservation::create([
                            
                                                            'residence_id'       =>  Auth::user()->street_id,
                                                            'payment_type'       =>  $request->payment_type,
                                                            'title'              =>  $request->title,
                                                            'date'               =>  $request->date,
                                                            'time_start'         =>  $request->time_start,
                                                            'time_end'           =>  $request->time_end,
                                                            'color'              =>  $area->color,
                                                            'reservation_status' =>  $status->id,
                                                            'social_area'        =>  $request->social_area,
                                                            'voucher_name'       =>  $fileName,
                                                            'url_voucher'        =>  $url.$fileName,
                                                            'voucher_type'       =>  $fileType,
                                                            'voucher_size'       =>  $fileSize,
                                                            'limit_date'         =>  $nuevafecha,
                                                            //'cant_asist'         =>  $request->cant_asist,
                            
                                                        ]);
                            
                                                        
                                                        $c = count($request->guest);
                                                        if($c == 1 )
                                                        {
                                                            for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                if(!empty($request->guest[$i]))
                                                                {
                                                                    $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                    ]);
                            
                                                                    $access = AccessType::where('name','invitado')->first();
                            
                                                                    AccessColony::create([
                            
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => Auth::user()->street_id,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }
                                                        }
                                                        else
                                                        {
                                                            for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                
                                                                
                                                                $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                ]);
                            
                                                                $access = AccessType::where('name','invitado')->first();
                            
                                                                AccessColony::create([
                            
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => Auth::user()->street_id,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                            
                                                        if($area->cost != null || $area->cost != "0")
                                                        {
                            
                                                            /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                                $category = IncomeCategory::where('name','areas')->first();
                                                                $actual_month = Admin::getActualMonth();
                                                                $status = Status::where('name','activo')->first();
                                                                $account = AccountReceivable::create([
                            
                                                                    'category'  => $category->id,
                                                                    'debt'      => $area->cost,
                                                                    'to_pay'    => $area->cost,
                                                                    'month'     => $actual_month->id,
                                                                    'residence' => Auth::user()->street_id,
                                                                    'estatus'    => $status->id,
                                                                    'description' => $area->name_social_area."-".$request->date,
                            
                                                                ]);
                                                            /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                        }
                                                        
                                                    }
                                                            
                                                }
                                                else
                                                {
                                                    $reservation = Reservation::create([
                            
                                                        'residence_id'       => Auth::user()->street_id,
                                                        'payment_type'       => $request->payment_type,
                                                        'title'              => $request->title,
                                                        'date'               => $request->date,
                                                        'time_start'         => $request->time_start,
                                                        'time_end'           => $request->time_end,
                                                        'color'              => $area->color,
                                                        'reservation_status' => $status->id,
                                                        'social_area'        => $request->social_area,
                                                        'limit_date'         => $nuevafecha,
                                                        //'cant_asist'         =>  $request->cant_asist,
                                                    ]);
                            
                                                    $c = count($request->guest);
                            
                                                    if($c == 1 )
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                            {
                                                                if(!empty($request->guest[$i]))
                                                                {
                                                                    $guest = Guest::create([
                            
                                                                    'name_guest'      => $request->guest[$i],
                                                                    'reservation_id'  => $reservation->id,
                                                                    ]);
                            
                                                                    $access = AccessType::where('name','invitado')->first();
                            
                                                                    AccessColony::create([
                            
                                                                        'date'          => $request->date,
                                                                        'residence_id'  => Auth::user()->street_id,
                                                                        'event_id'      => $reservation->id,
                                                                        'guest_id'      => $guest->id,
                                                                        'type'          => $access->id,
                                                                    ]);
                                                                }
                                                            }
                                                    }
                                                    else
                                                    {
                            
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            $guest = Guest::create([
                            
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                            
                            
                                                            $access = AccessType::where('name','invitado')->first();
                            
                                                            AccessColony::create([
                            
                                                                'date'          => $request->date,
                                                                'residence_id'  => Auth::user()->street_id,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                            
                                                    if($area->cost != null || $area->cost != "0")
                                                    {
                            
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                            $category = IncomeCategory::where('name','areas')->first();
                                                            $actual_month = Admin::getActualMonth();
                                                            $status = Status::where('name','activo')->first();
                                                            $account = AccountReceivable::create([
                            
                                                                'category'  => $category->id,
                                                                'debt'      => $area->cost,
                                                                'to_pay'    => $area->cost,
                                                                'month'     => $actual_month->id,
                                                                'residence' => Auth::user()->street_id,
                                                                'deadline'  => $nuevafecha,
                                                                'estatus'    => $status->id,
                                                                'description' => $area->name_social_area."-".$request->date,
                            
                                                            ]);
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                    }
                            
                                                }
                                            }
                                        }else if($limit == "0"){
                                            if($area->cost == null || $area->cost == "0")
                                            {
                                                $status = Status::where('name','reservado')->first();
                                                $payment_type = 1;
                                            }
                                            else
                                            {
                                                $status = Status::where('name','pendiente')->first();
                                                $payment_type = $request->payment_type;
                                            } 
                                            
                                            $date = Carbon::now();
                                            $dias = $area->days_reserve_stay;
                                            $nuevafecha = strtotime ('+'.$dias.'day' , strtotime( $date->toDateString()));
                                            $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                        
                        
                                            if (Input::hasFile('file'))
                                            {
                                                $fileInput= Input::file('file');
                                                $fileName = $fileInput->getClientOriginalName();
                                                $path = public_path().'/uploads/vouchers/incomes/';
                                                $url = '/uploads/vouchers/incomes/';
                                                $fileType = $fileInput->getMimeType();
                                                $fileSize = $fileInput->getClientSize()/1024;
                        
                        
                                                if($fileInput->move($path,$fileName))
                                                {       
                                                    $reservation = Reservation::create([
                        
                                                        'residence_id'       =>  Auth::user()->street_id,
                                                        'payment_type'       =>  $request->payment_type,
                                                        'title'              =>  $request->title,
                                                        'date'               =>  $request->date,
                                                        'time_start'         =>  $request->time_start,
                                                        'time_end'           =>  $request->time_end,
                                                        'color'              =>  $area->color,
                                                        'reservation_status' =>  $status->id,
                                                        'social_area'        =>  $request->social_area,
                                                        'voucher_name'       =>  $fileName,
                                                        'url_voucher'        =>  $url.$fileName,
                                                        'voucher_type'       =>  $fileType,
                                                        'voucher_size'       =>  $fileSize,
                                                        'limit_date'         =>  $nuevafecha,
                                                        //'cant_asist'         =>  $request->cant_asist,
                        
                                                    ]);
                        
                                                    
                                                    $c = count($request->guest);
                                                    if($c == 1 )
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            if(!empty($request->guest[$i]))
                                                            {
                                                                $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                                ]);
                        
                                                                $access = AccessType::where('name','invitado')->first();
                        
                                                                AccessColony::create([
                        
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => Auth::user()->street_id,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                                                    }
                                                    else
                                                    {
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            
                                                            
                                                            $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                        
                                                            $access = AccessType::where('name','invitado')->first();
                        
                                                            AccessColony::create([
                        
                                                                'date'          => $request->date,
                                                                'residence_id'  => Auth::user()->street_id,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                        
                                                    if($area->cost != null || $area->cost != "0")
                                                    {
                        
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                            $category = IncomeCategory::where('name','areas')->first();
                                                            $actual_month = Admin::getActualMonth();
                                                            $status = Status::where('name','activo')->first();
                                                            $account = AccountReceivable::create([
                        
                                                                'category'  => $category->id,
                                                                'debt'      => $area->cost,
                                                                'to_pay'    => $area->cost,
                                                                'month'     => $actual_month->id,
                                                                'residence' => Auth::user()->street_id,
                                                                'estatus'    => $status->id,
                                                                'description' => $area->name_social_area."-".$request->date,
                        
                                                            ]);
                                                        /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                    }
                                                    
                                                }
                                                        
                                            }
                                            else
                                            {
                                                
                                                $reservation = Reservation::create([
                        
                                                    'residence_id'       => Auth::user()->street_id,
                                                    'payment_type'       => $request->payment_type,
                                                    'title'              => $request->title,
                                                    'date'               => $request->date,
                                                    'time_start'         => $request->time_start,
                                                    'time_end'           => $request->time_end,
                                                    'color'              => $area->color,
                                                    'reservation_status' => $status->id,
                                                    'social_area'        => $request->social_area,
                                                    'limit_date'         => $nuevafecha,
                                                    //'cant_asist'         =>  $request->cant_asist,
                                                ]);
                                                
                                                $c = count($request->guest);
                        
                                                if($c == 1 )
                                                {
                                                    //#AquiSi
                                                    if($request->cant_asist <= $CAsist){
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            if(!empty($request->guest[$i]))
                                                            if(!empty($request->guest[$i]))
                                                            {
                                                                $guest = Guest::create([
                        
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                                ]);
                        
                                                                $access = AccessType::where('name','invitado')->first();
                        
                                                                AccessColony::create([
                        
                                                                    'date'          => $request->date,
                                                                    'residence_id'  => Auth::user()->street_id,
                                                                    'event_id'      => $reservation->id,
                                                                    'guest_id'      => $guest->id,
                                                                    'type'          => $access->id,
                                                                ]);
                                                            }
                                                        }
                                                    }else{
                                                        $conteo = (count($request->guest));
                                                        $conteo2 = $CAsist-1;
                                                        $cantidad = $request->cant_asist;
                                                        $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                        return redirect()->back()
                                                            ->withErrors($errors);
                                                    }
                                                }
                                                else
                                                {
                                                    //#AquiSi
                                                    if($request->cant_asist <= $CAsist){
                                                        for ($i=0; $i < count($request->guest); $i++)
                                                        {
                                                            $guest = Guest::create([
                            
                                                                'name_guest'      => $request->guest[$i],
                                                                'reservation_id'  => $reservation->id,
                                                            ]);
                            
                            
                                                            $access = AccessType::where('name','invitado')->first();
                            
                                                            AccessColony::create([
                            
                                                                'date'          => $request->date,
                                                                'residence_id'  => Auth::user()->street_id,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }else{
                                                        $conteo = (count($request->guest));
                                                        $conteo2 = $CAsist-1;
                                                        $cantidad = $request->cant_asist;
                                                        $errors = ['error' => "Solo puedes reservar esta area social para {$conteo2} asistentes({$CAsist} ya incluyendote) y quisiste reservar para {$cantidad}."];
                                                        return redirect()->back()
                                                            ->withErrors($errors);
                                                    }
                                                }
                        
                                                if($area->cost != null || $area->cost != "0")
                                                {
                        
                                                    /*** GENERAR PAGO DE CUOTA DE AREA **/
                                                        $category = IncomeCategory::where('name','areas')->first();
                                                        $actual_month = Admin::getActualMonth();
                                                        $status = Status::where('name','activo')->first();
                                                        $account = AccountReceivable::create([
                        
                                                            'category'  => $category->id,
                                                            'debt'      => $area->cost,
                                                            'to_pay'    => $area->cost,
                                                            'month'     => $actual_month->id,
                                                            'residence' => Auth::user()->street_id,
                                                            'deadline'  => $nuevafecha,
                                                            'estatus'    => $status->id,
                                                            'description' => $area->name_social_area."-".$request->date,
                        
                                                        ]);
                                                    /*** GENERAR PAGO DE CUOTA DE AREA **/ 
                                                }
                        
                                            }
                                        }
                                    
                                        
                                        /*if($area->cost == null || $area->cost == "0")
                                        {
                                            $status = Status::where('name','reservado')->first();
                                            $payment_type = 1;
                                        }
                                        else
                                        {
                                            $status = Status::where('name','pendiente')->first();
                                            $payment_type = $request->payment_type;
                                        } 
                                        
                                        $date = Carbon::now();
                                        $dias = $area->days_reserve_stay;
                                        $nuevafecha = strtotime ('+'.$dias.'day' , strtotime( $date->toDateString()));
                                        $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                    
                    
                                        if (Input::hasFile('file'))
                                        {
                    
                                            $fileInput= Input::file('file');
                                            $fileName = $fileInput->getClientOriginalName();
                                            $path = public_path().'/uploads/vouchers/incomes/';
                                            $url = '/uploads/vouchers/incomes/';
                                            $fileType = $fileInput->getMimeType();
                                            $fileSize = $fileInput->getClientSize()/1024;
                    
                    
                                            if($fileInput->move($path,$fileName))
                                            {       
                                                $reservation = Reservation::create([
                    
                                                    'residence_id'       =>  Auth::user()->street_id,
                                                    'payment_type'       =>  $request->payment_type,
                                                    'title'              =>  $request->title,
                                                    'date'               =>  $request->date,
                                                    'time_start'         =>  $request->time_start,
                                                    'time_end'           =>  $request->time_end,
                                                    'color'              =>  $area->color,
                                                    'reservation_status' =>  $status->id,
                                                    'social_area'        =>  $request->social_area,
                                                    'voucher_name'       =>  $fileName,
                                                    'url_voucher'        =>  $url.$fileName,
                                                    'voucher_type'       =>  $fileType,
                                                    'voucher_size'       =>  $fileSize,
                                                    'limit_date'         =>  $nuevafecha,
                    
                                                ]);
                    
                                                
                                                $c = count($request->guest);
                                                if($c == 1 )
                                                {
                                                    for ($i=0; $i < count($request->guest); $i++)
                                                    {
                                                        if(!empty($request->guest[$i]))
                                                        {
                                                            $guest = Guest::create([
                    
                                                            'name_guest'      => $request->guest[$i],
                                                            'reservation_id'  => $reservation->id,
                                                            ]);
                    
                                                            $access = AccessType::where('name','invitado')->first();
                    
                                                            AccessColony::create([
                    
                                                                'date'          => $request->date,
                                                                'residence_id'  => Auth::user()->street_id,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    for ($i=0; $i < count($request->guest); $i++)
                                                    {
                                                        
                                                        
                                                        $guest = Guest::create([
                    
                                                            'name_guest'      => $request->guest[$i],
                                                            'reservation_id'  => $reservation->id,
                                                        ]);
                    
                                                        $access = AccessType::where('name','invitado')->first();
                    
                                                        AccessColony::create([
                    
                                                            'date'          => $request->date,
                                                            'residence_id'  => Auth::user()->street_id,
                                                            'event_id'      => $reservation->id,
                                                            'guest_id'      => $guest->id,
                                                            'type'          => $access->id,
                                                        ]);
                                                    }
                                                }
                    
                                                if($area->cost != null || $area->cost != "0")
                                                {
                    
                                                    /*** GENERAR PAGO DE CUOTA DE AREA 
                                                        $category = IncomeCategory::where('name','areas')->first();
                                                        $actual_month = Admin::getActualMonth();
                                                        $status = Status::where('name','activo')->first();
                                                        $account = AccountReceivable::create([
                    
                                                            'category'  => $category->id,
                                                            'debt'      => $area->cost,
                                                            'to_pay'    => $area->cost,
                                                            'month'     => $actual_month->id,
                                                            'residence' => Auth::user()->street_id,
                                                            'estatus'    => $status->id,
                                                            'description' => $area->name_social_area."-".$request->date,
                    
                                                        ]);
                                                    /*** GENERAR PAGO DE CUOTA DE AREA 
                                                }
                                                
                                            }
                                                    
                                        }
                                        else
                                        {
                                            $reservation = Reservation::create([
                    
                                                'residence_id'       => Auth::user()->street_id,
                                                'payment_type'       => $request->payment_type,
                                                'title'              => $request->title,
                                                'date'               => $request->date,
                                                'time_start'         => $request->time_start,
                                                'time_end'           => $request->time_end,
                                                'color'              => $area->color,
                                                'reservation_status' => $status->id,
                                                'social_area'        => $request->social_area,
                                                'limit_date'         => $nuevafecha,
                                            ]);
                    
                                            $c = count($request->guest);
                    
                                            if($c == 1 )
                                            {
                                                for ($i=0; $i < count($request->guest); $i++)
                                                    {
                                                        if(!empty($request->guest[$i]))
                                                        {
                                                            $guest = Guest::create([
                    
                                                            'name_guest'      => $request->guest[$i],
                                                            'reservation_id'  => $reservation->id,
                                                            ]);
                    
                                                            $access = AccessType::where('name','invitado')->first();
                    
                                                            AccessColony::create([
                    
                                                                'date'          => $request->date,
                                                                'residence_id'  => Auth::user()->street_id,
                                                                'event_id'      => $reservation->id,
                                                                'guest_id'      => $guest->id,
                                                                'type'          => $access->id,
                                                            ]);
                                                        }
                                                    }
                                            }
                                            else
                                            {
                    
                                                for ($i=0; $i < count($request->guest); $i++)
                                                {
                                                    $guest = Guest::create([
                    
                                                        'name_guest'      => $request->guest[$i],
                                                        'reservation_id'  => $reservation->id,
                                                    ]);
                    
                    
                                                    $access = AccessType::where('name','invitado')->first();
                    
                                                    AccessColony::create([
                    
                                                        'date'          => $request->date,
                                                        'residence_id'  => Auth::user()->street_id,
                                                        'event_id'      => $reservation->id,
                                                        'guest_id'      => $guest->id,
                                                        'type'          => $access->id,
                                                    ]);
                                                }
                                            }
                    
                                            if($area->cost != null || $area->cost != "0")
                                            {
                    
                                                /*** GENERAR PAGO DE CUOTA DE AREA 
                                                    $category = IncomeCategory::where('name','areas')->first();
                                                    $actual_month = Admin::getActualMonth();
                                                    $status = Status::where('name','activo')->first();
                                                    $account = AccountReceivable::create([
                    
                                                        'category'  => $category->id,
                                                        'debt'      => $area->cost,
                                                        'to_pay'    => $area->cost,
                                                        'month'     => $actual_month->id,
                                                        'residence' => Auth::user()->street_id,
                                                        'deadline'  => $nuevafecha,
                                                        'estatus'    => $status->id,
                                                        'description' => $area->name_social_area."-".$request->date,
                    
                                                    ]);
                                                /*** GENERAR PAGO DE CUOTA DE AREA 
                                            }
                    
                                        }*/
                                        //#Fin limite de eventos
                                    }else{
                                        $errors = ['error' => "Esta area social actualmente tiene disponible solo {$CARest} lugares, asegurate que tu cantidad de asistentes no sobre pase la cantidad disponible({$CARest}) y la cantidad por residencia({$CAsist})."];
                                        return redirect()->back()
                                            ->withErrors($errors);
                                    }
                                }else{
                                    $CARest = ($CAfore - $AforeT);
                                    $errors = ['error' => "Esta area social actualmente tiene disponible solo {$CARest} lugares, asegurate que tu cantidad de asistentes no sobre pase la cantidad disponible({$CARest}) y la cantidad por residencia({$CAsist})."];
                                    return redirect()->back()
                                        ->withErrors($errors);
                                }
                            }else{
                                $errors = ['error' => "El area social seleccionada ya esta en su limite de reservas para la fecha {$FechaV}.    El limite de casas que pueden reservar a la vez: {$CCasas}. "];
                                return redirect()->back()
                                    ->withErrors($errors);
                            }
                        }else{
                            $errors = ['error' => "Ya tienes una reserva en esta area social el {$FechaV}"];
                            return redirect()->back()
                                ->withErrors($errors);
                        }   
                    }else{
                        $errors = ['error' => "Las reservas solo se pueden hacer entre {$dateInitial} - {$date2}"];
                        return redirect()->back()
                            ->withErrors($errors);
                    }
                    
                    
                    
                }

            DB::commit();

            return redirect()->action('ReservationResController@index', ['abierto' => "1"]);

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function show(Reservation $reservation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function edit(Reservation $reservation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Reservation $reservation,$id)
    {
        
        
         try{

            $reserv = Reservation::findOrfail($id);
          
            $messages = [
                'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                'max'   => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
            ];

            $rules = [
                'file' => 'max:5000|mimes:jpeg,jpg,png,pdf',
            ];


            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                if (Input::hasFile('file'))
                {

                    
                    $status = Status::where('name','confirmar')->first();

                    if(empty($request->payment_type) || is_null($request->payment_type))
                    {
                        $guest = Guest::where('reservation_id', $reserv->id)->get();
                        if(!$request->name_guest)
                        {
                            $guest = Guest::where('reservation_id', $reserv->id);
                            $guest->delete();
                            $access = AccessColony::where('event_id', $reserv->id);
                            $access->delete();

                        }
                        else
                        {
                            if($request->name_guest)
                            {
                                foreach ($guest as $guests)
                                {                             
                                    if(!in_array($guests->id,$request->id_guest))
                                    { 
                                        $g = Guest::findOrfail($guests->id);
                                        $access = AccessColony::where('guest_id',$guests->id)->whereNull('check_in');
                                        $g->delete();  
                                        $access->delete(); 
                                    }   
                                }
                            }
                        }
                                              
                                    

                        $c = count($request->name_guest2);
                        if($c == 1 )
                        {
                            for ($i=0; $i < count($request->name_guest2); $i++)
                            {
                                if(!empty($request->name_guest2[$i]))
                                {
                                    if($request->name_guest2)
                                    {
                                        for ($i=0; $i < count($request->name_guest2); $i++)
                                        {
                                            $guest = Guest::create([
                                                'name_guest'      => $request->name_guest2[$i],
                                                'reservation_id'  => $reserv->id,
                                            ]);
                                            $access = AccessType::where('name','invitado')->first();

                                                AccessColony::create([

                                                    'date'          => $reserv->date,
                                                    'residence_id'  => $reserv->residence_id,
                                                    'event_id'      => $reserv->id,
                                                    'guest_id'      => $guest->id,
                                                    'type'          => $access->id,
                                                ]);
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {

                            if($request->name_guest2)
                            {
                                for ($i=0; $i < count($request->name_guest2); $i++)
                                {
                                    $guest = Guest::create([
                                        'name_guest'      => $request->name_guest2[$i],
                                        'reservation_id'  => $reserv->id,
                                    ]);

                                    $access = AccessType::where('name','invitado')->first();

                                    AccessColony::create([

                                        'date'          => $reserv->date,
                                        'residence_id'  => $reserv->residence_id,
                                        'event_id'      => $reserv->id,
                                        'guest_id'      => $guest->id,
                                        'type'          => $access->id,
                                    ]);
                                }
                            }
                        }
                    }
                    else
                    {

                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }

                            $name_imagen = $reserv->id.".".$type;
                            $url = '/uploads/vouchers/incomes/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData*1024;

                            if($request->imageData)
                            {
                                $data = base64_decode($request->imageData);
                                $im = imagecreatefromstring($data);
                                if ($im !== false) 
                                {
                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);
                                                   
                                    $reserv->update([

                                        'voucher_name'       =>  $name_imagen,
                                        'url_voucher'        =>  $url.$name_imagen,
                                        'voucher_type'       =>  $request->contentType,
                                        'voucher_size'       =>  $peso,
                                        'payment_type'       =>  $request->payment_type,
                                        'reservation_status' =>  $status->id,
                                    ]);  
                                        
                                    imagedestroy($im);
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                        return redirect()->back()
                                        ->withErrors($errors);
                                }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                    return redirect()->back()
                                    ->withErrors($errors);
                            }

                        }
                        else
                        {

                            
                            $path = public_path().'/uploads/vouchers/incomes/';
                            $url = '/uploads/vouchers/incomes/';
                            $fileType = $fileInput->getMimeType();
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }

                            $fileName = $reserv->id.".".$type;
                            $fileSize = $fileInput->getClientSize()/1024;
                            
                            if($fileInput->move($path,$fileName))
                            {       

                                $reserv->update([

                                    'voucher_name'       =>  $fileName,
                                    'url_voucher'        =>  $url.$fileName,
                                    'voucher_type'       =>  $fileType,
                                    'voucher_size'       =>  $fileSize,
                                    'payment_type'       =>  $request->payment_type,
                                    'reservation_status' =>  $status->id,
                                ]);  
                            }
                        }

                        
                        $guest = Guest::where('reservation_id', $reserv->id)->get();
                        if(!$request->name_guest)
                        {
                            $guest = Guest::where('reservation_id', $reserv->id);
                            $guest->delete();
                            $access = AccessColony::where('event_id', $reserv->id);
                            $access->delete();

                        }
                        else
                        {
                            
                            if($request->name_guest)
                            {
                                foreach ($guest as $guests)
                                {                             
                                    if(!in_array($guests->id,$request->id_guest))
                                    { 
                                        $g = Guest::findOrfail($guests->id);
                                        $access = AccessColony::where('guest_id',$guests->id)->whereNull('check_in');
                                        $g->delete();  
                                        $access->delete(); 
                                    }   
                                }
                            }
                        }
                                          
                                
                        $c = count($request->name_guest2);
                        if($c == 1 )
                        {
                            for ($i=0; $i < count($request->name_guest2); $i++)
                            {
                                
                                if(!empty($request->name_guest2[$i]))
                                {
                                    if($request->name_guest2)
                                    {
                                        for ($i=0; $i < count($request->name_guest2); $i++)
                                        {
                                            $guest = Guest::create([
                                                'name_guest'      => $request->name_guest2[$i],
                                                'reservation_id'  => $reserv->id,
                                            ]);

                                            $access = AccessType::where('name','invitado')->first();

                                            AccessColony::create([

                                                'date'          => $reserv->date,
                                                'residence_id'  => $reserv->residence_id,
                                                'event_id'      => $reserv->id,
                                                'guest_id'      => $guest->id,
                                                'type'          => $access->id,
                                            ]);
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {

                            if($request->name_guest2)
                            {
                                for ($i=0; $i < count($request->name_guest2); $i++)
                                {
                                    $guest = Guest::create([
                                        'name_guest'      => $request->name_guest2[$i],
                                        'reservation_id'  => $reserv->id,
                                    ]);

                                    $access = AccessType::where('name','invitado')->first();

                                    AccessColony::create([

                                        'date'          => $reserv->date,
                                        'residence_id'  => $reserv->residence_id,
                                        'event_id'      => $reserv->id,
                                        'guest_id'      => $guest->id,
                                        'type'          => $access->id,
                                    ]);
                                }
                            }
                        }
                    }
                }
                else
                {

                    $guest = Guest::where('reservation_id', $reserv->id)->get();
                    if(!$request->name_guest)
                    {
                        $guest = Guest::where('reservation_id', $reserv->id);
                        $guest->delete();
                        $access = AccessColony::where('event_id', $reserv->id);
                        $access->delete();

                    }
                    else
                    {
                        if($request->name_guest)
                        {
                            foreach ($guest as $guests)
                            {                             
                                if(!in_array($guests->id,$request->id_guest))
                                { 
                                    $g = Guest::findOrfail($guests->id);
                                    $access = AccessColony::where('guest_id',$guests->id)->whereNull('check_in');
                                    $g->delete();  
                                    $access->delete(); 
                                }   
                            }
                        }
                    }

                    $c = count($request->name_guest2);
                    if($c == 1 )
                    {
                        $errors = ['error' => "1"];
                                                            return redirect()->back()
                                                                ->withErrors($errors);
                        for ($i=0; $i < count($request->name_guest2); $i++)
                        {
                            if(!empty($request->name_guest2[$i]))
                            {
                                if($request->name_guest2)
                                {
                                    for ($i=0; $i < count($request->name_guest2); $i++)
                                    {
                                        $guest = Guest::create([
                                            'name_guest'      => $request->name_guest2[$i],
                                            'reservation_id'  => $reserv->id,
                                         ]);
                                        $access = AccessType::where('name','invitado')->first();

                                        AccessColony::create([

                                            'date'          => $reserv->date,
                                            'residence_id'  => $reserv->residence_id,
                                            'event_id'      => $reserv->id,
                                            'guest_id'      => $guest->id,
                                            'type'          => $access->id,
                                        ]);
                                    }
                                }
                            }
                        }
                    }
                    else
                    {

                        if($request->name_guest2)
                        {
                            for ($i=0; $i < count($request->name_guest2); $i++)
                            {
                                $guest = Guest::create([
                                    'name_guest'      => $request->name_guest2[$i],
                                    'reservation_id'  => $reserv->id,
                                ]);

                                $access = AccessType::where('name','invitado')->first();

                                AccessColony::create([

                                    'date'          => $reserv->date,
                                    'residence_id'  => $reserv->residence_id,
                                    'event_id'      => $reserv->id,
                                    'guest_id'      => $guest->id,
                                    'type'          => $access->id,
                                ]);
                            }
                        }
                    }

                }
            }


            if($request->resd)
            {
                return redirect('reservation/resident');
            }
            else
            {
                return redirect('reservations');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Reservation  $reservation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Reservation $reservation,$id)
    {
        try{

            DB::beginTransaction();
            // #Boton cancelar en evento gratuito
                try {

                $user     = Auth::user();
                $reserv   = Reservation::findOrfail($id);
                $area     = SocialArea::findOrfail($reserv->social_area);
                $category = IncomeCategory::where('name','areas')->first();

                $status = Status::where('name',"cancelado")->first();

                $reserv->update([

                    'reservation_status' => $status->id,
                ]);

                $account = AccountReceivable::where('residence',$reserv->residence_id)->where('to_pay',$area->cost)->where('category',$category->id)->first();
               
                if(empty($account))
                {

                }
                else
                {
                    $account->update([

                        'estatus' => $status->id,
                    ]);
                    
                    $account->delete();
                }

                $guest = AccessColony::where('event_id', $reserv->id);
                $guest->delete();
            } catch (\Throwable $th) {
                //throw $th;
            }
            DB::commit();

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
