<?php

namespace App\Http\Controllers;

use App\SocialArea;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Auth;
use Session;
use DB;


class SocialAreaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
      
        if($user->can('index', \App\Street::class))
        {
            $social_area = SocialArea::paginate(15);
            $a = 0;
            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }
            return view('configuration.social_areas.index', compact('social_area','a','abierto'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
        if($user->can('create', \App\Street::class ))
        {
            return view('configuration.social_areas.create');
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        
        try{



            DB::beginTransaction();

                
                $messages = [

                    'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'   => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                    'required'  => 'Este campo es requerido.',
                ];

                $rules = [

                    'file'              => 'max:5000|mimes:jpeg,jpg,png,pdf',//5000kb pdf
                    'name_social_area'  => 'required',
                    'cost'              => 'required',
                    'color'             => 'required',
                ];

                $validator = Validator::make($request->all(),$rules,$messages);
                $Multi = (($request->cant_casas)*($request->limit_asist));

                if ($validator->fails()) {
                    return redirect()->back()
                                ->withErrors($validator)
                                ->withInput();
                }
                else//if($Multi <= $request->limit_aforo)
                {
                    /*$errors = ['error' => $Multi];
                    return redirect()->back()
                        ->withErrors($errors);*/
                    if($request->monday){$monday = "1";}else{$monday = "0";}
                    if($request->tuesday){$tuesday = "1";}else{$tuesday = "0";}
                    if($request->wendsday){$wendsday = "1";}else{$wendsday = "0";}
                    if($request->thursday){$thursday = "1";}else{$thursday = "0";}
                    if($request->friday){$friday = "1";}else{$friday = "0";}
                    if($request->saturday){$saturday = "1";}else{$saturday = "0";}
                    if($request->sunday){$sunday = "1";}else{$sunday = "0";}
                    if($request->limit_event){$limit_event = "1";}else{$limit_event = "0";}//#Agrega el checkbox para limitar eventos por casa
                    if($request->ocult_area){$ocult_area = "1";}else{$ocult_area = "0";}


                    if (Input::hasFile('file'))
                    {

                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            
                           
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            if($request->imageData)
                            {
                              $data = base64_decode($request->imageData);
                              $im = imagecreatefromstring($data);
                              if ($im !== false) 
                              {
                                    
                               
                                    $file = new SocialArea;
                                    $file->name_social_area = $request->name_social_area;
                                    $file->monday = $monday;
                                    $file->tuesday = $tuesday;
                                    $file->wendsday = $wendsday;
                                    $file->thursday = $thursday;
                                    $file->friday = $friday;
                                    $file->saturday = $saturday;
                                    $file->sunday = $sunday;
                                    $file->limit_event = $limit_event;//#Agrega el checkbox para limitar eventos por casa
                                    $file->cost = $request->cost;
                                    $file->days_reserve_stay = $request->days_reserve_stay; 
                                    $file->color = $request->color;
                                    $file->ocult_area = $ocult_area;
                                    $file->cant_casas = $request->cant_casas;
                                    $file->limit_aforo = $request->limit_aforo;
                                    $file->limit_asist = $request->limit_asist;
                                    $file->save();

                                    $name_imagen = $file->id.".".$type;
                                    $url = '/uploads/rules_social_areas/';
                                    $path = public_path().$url.$name_imagen;
                                    $peso = $request->sizeData*1024;

                                    $file->update([

                                      'name_file' => $name_imagen,
                                      'url_file'  => $url.$name_imagen,
                                      'type_file' => $request->contentType,
                                      'size_file' => $peso,

                                    ]);

                                    

                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);

                                    imagedestroy($im);
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                   return redirect()->back()
                                      ->withErrors($errors);
                              }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                  return redirect()->back()
                                      ->withErrors($errors);
                            }

                        }
                        else
                        {
                            /** OBTENER INFORMACIÓN DEL ARCHIVO CARGADO **/
                            
                            $path = public_path().'/uploads/rules_social_areas/';
                            $url = '/uploads/rules_social_areas/';
                            $fileType = $fileInput->getMimeType();
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            $fileSize = $fileInput->getClientSize()/1024;

                            
                            $file = new SocialArea;
                            $file->name_social_area = $request->name_social_area;
                            $file->monday = $monday;
                            $file->tuesday = $tuesday;
                            $file->wendsday = $wendsday;
                            $file->thursday = $thursday;
                            $file->friday = $friday;
                            $file->saturday = $saturday;
                            $file->sunday = $sunday;
                            $file->limit_event = $limit_event;//#Agrega el checkbox para limitar eventos por casa
                            $file->cost = $request->cost;
                            $file->days_reserve_stay = $request->days_reserve_stay; 
                            $file->color = $request->color;
                            $file->ocult_area = $ocult_area;
                            $file->cant_casas = $request->cant_casas;
                            $file->limit_aforo = $request->limit_aforo;
                            $file->limit_asist = $request->limit_asist;
                            $file->save();

                            $fileName = $file->id.".".$type;

                            if($fileInput->move($path,$fileName))
                            {       
                                $file->update([

                                    'name_file' => $fileName,
                                    'url_file'  => $url.$fileName,
                                    'type_file' => $fileType,
                                    'size_file' => $fileSize,

                                ]);
                            }
                        }
                        
                    }
                    else
                    {
                        $file = new SocialArea;
                        $file->name_social_area = $request->name_social_area;
                        $file->monday = $monday;
                        $file->tuesday = $tuesday;
                        $file->wendsday = $wendsday;
                        $file->thursday = $thursday;
                        $file->friday = $friday;
                        $file->saturday = $saturday;
                        $file->sunday = $sunday;
                        $file->limit_event = $limit_event;//#Agrega el checkbox para limitar eventos por casa
                        $file->cost = $request->cost;
                        $file->days_reserve_stay = $request->days_reserve_stay; 
                        $file->color = $request->color;
                        $file->ocult_area = $ocult_area;
                        $file->cant_casas = $request->cant_casas;
                        $file->limit_aforo = $request->limit_aforo;
                        $file->limit_asist = $request->limit_asist;
                        $file->save();
                        
                    }
                }/*else{
                    $CantC = $request->cant_casas;
                    $CantA = $request->limit_asist;
                    $CantAf = $request->limit_aforo;
                    $errors = ['error' => "El producto de la cantidad de casas que pueden rentar un area social y la cantidad de asistentes por residencia es mayor que la cantidad de aforo: ( ({$CantC} * {$CantA}) > {$CantAf} )."];
                                  return redirect()->back()
                                      ->withErrors($errors);
                }*/

                DB::commit();

                return redirect()->action('SocialAreaController@index', ['abierto' => "1"]);

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);

            
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\SocialArea  $socialArea
     * @return \Illuminate\Http\Response
     */
    public function show(SocialArea $socialArea)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\SocialArea  $socialArea
     * @return \Illuminate\Http\Response
     */
    public function edit(SocialArea $socialArea)
    {

        try{

            $user = Auth::user();
            if($user->can('edit', $socialArea))
            {
                return view('configuration.social_areas.edit', compact('socialArea'));
            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\SocialArea  $socialArea
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SocialArea $socialArea)
    {
        
        try{

                $user = Auth::user();

                if($user->can('update', $socialArea))
                {
                    $messages = [

                        'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                        'max'   => 'el archivo no debe pesar mas de 5 mb.',
                        'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                        'required'  => 'Este campo es requerido.',
                    ];

                    $rules = [

                        'file' => 'max:5000|mimes:jpeg,jpg,png,pdf',//5000kb pdf
                        'name_social_area'  => 'required',
                        'cost'              => 'required',
                        'color'             => 'required',
                    ];

                    $validator = Validator::make($request->all(),$rules,$messages);
                    $Multi = (($request->cant_casas)*($request->limit_asist));

                    if ($validator->fails()) {
                        return redirect()->back()
                            ->withErrors($validator)
                            ->withInput();
                    }
                    else//if($Multi <= $request->limit_aforo)
                    {
                        /*$errors = ['error' => $Multi];
                        return redirect()->back()
                            ->withErrors($errors);*/
                        if($request->monday){$monday = "1";}else{$monday = "0";}
                        if($request->tuesday){$tuesday = "1";}else{$tuesday = "0";}
                        if($request->wendsday){$wendsday = "1";}else{$wendsday = "0";}
                        if($request->thursday){$thursday = "1";}else{$thursday = "0";}
                        if($request->friday){$friday = "1";}else{$friday = "0";}
                        if($request->saturday){$saturday = "1";}else{$saturday = "0";}
                        if($request->sunday){$sunday = "1";}else{$sunday = "0";}
                        if($request->limit_event){$limit_event = "1";}else{$limit_event = "0";}//#Agrega el checkbox para limitar eventos por casa
                        if($request->ocult_area){$ocult_area = "1";}else{$ocult_area = "0";}

                        $fileInput= Input::file('file');

                        if (Input::hasFile('file'))
                        {

                            $fileInput= Input::file('file');
                            $fileType = $fileInput->getMimeType();
                            $clave = str_random(5);

                            if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                            { 
                                if($fileType == "image/jpeg")
                                {
                                    $type = "jpg";
                                }
                                else if($fileType == "application/pdf")
                                {
                                    $type = "pdf";
                                }
                                else if($fileType == "image/png")
                                {
                                    $type = "png";
                                }

                                $name_imagen = $socialArea->id.".".$type;
                                $url = '/uploads/rules_social_areas/';
                                $path = public_path().$url.$name_imagen;
                                $peso = $request->sizeData*1024;

                                if($request->imageData)
                                {
                                  $data = base64_decode($request->imageData);
                                  $im = imagecreatefromstring($data);

                                  $img = public_path().$socialArea->url_file;
                                  $old_img = $socialArea->url_file;
                               

                                  if ($im !== false) 
                                  {
                                        header('Content-Type: ',$request->contentData);
                                        imagejpeg($im, $path);
                                   
                                        $socialArea->update([

                                            'name_social_area' => $request->name_social_area,
                                            'monday' => $monday,
                                            'tuesday' => $tuesday,
                                            'wendsday' => $wendsday,
                                            'thursday' => $thursday,
                                            'friday'=> $friday,
                                            'saturday' => $saturday,
                                            'sunday' => $sunday,
                                            'limit_event' => $limit_event,//#Agrega el checkbox para limitar eventos por casa
                                            'name_file' => $name_imagen,
                                            'url_file' => $url.$name_imagen,
                                            'type_file' => $request->contentType,
                                            'size_file' => $peso,
                                            'cost' => $request->cost,
                                            'days_reserve_stay' => $request->days_reserve_stay,
                                            'color' => $request->color,
                                            'ocult_area' => $ocult_area,
                                            'cant_casas' => $request->cant_casas,
                                            'limit_aforo' => $request->limit_aforo,
                                            'limit_asist' => $request->limit_asist,
                                        ]); 

                                        imagedestroy($im);

                                        /*if(!is_null($old_img))
                                        {
                                            unlink($img);
                                        }*/
                                        
                                  }
                                  else 
                                  {
                                      $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                       return redirect()->back()
                                          ->withErrors($errors);
                                  }
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                      return redirect()->back()
                                          ->withErrors($errors);
                                }

                            }
                            else
                            {
                                
                                $path = public_path().'/uploads/rules_social_areas/';
                                $url = '/uploads/rules_social_areas/';
                                $fileType = $fileInput->getMimeType();
                                if($fileType == "image/jpeg")
                                {
                                    $type = "jpg";
                                }
                                else if($fileType == "application/pdf")
                                {
                                    $type = "pdf";
                                }
                                else if($fileType == "image/png")
                                {
                                    $type = "png";
                                }
                                $fileName = $socialArea->id.".".$type;
                                $fileSize = $fileInput->getClientSize()/1024;

                                $img = public_path().$socialArea->url_file;
                                $old_img = $socialArea->url_file;

                               

                                if($fileInput->move($path,$fileName))
                                {       
                                    $socialArea->update([

                                        'name_social_area' => $request->name_social_area,
                                        'monday' => $monday,
                                        'tuesday' => $tuesday,
                                        'wendsday' => $wendsday,
                                        'thursday' => $thursday,
                                        'friday'=> $friday,
                                        'saturday' => $saturday,
                                        'sunday' => $sunday,
                                        'limit_event' => $limit_event,//#Agrega el checkbox para limitar eventos por casa
                                        'name_file' => $fileName,
                                        'url_file' => $url.$fileName,
                                        'type_file' => $fileType,
                                        'size_file' => $fileSize,
                                        'cost' => $request->cost,
                                        'days_reserve_stay' => $request->days_reserve_stay,
                                        'color' => $request->color,
                                        'ocult_area' => $ocult_area,
                                        'cant_casas' => $request->cant_casas,
                                        'limit_aforo' => $request->limit_aforo,
                                        'limit_asist' => $request->limit_asist,
                                    ]); 

                                    /*if(!is_null($old_img))
                                    {
                                        unlink($img);
                                    }*/
                                }
                                else
                                {
                                    $socialArea->update([

                                        'name_social_area' => $request->name_social_area,
                                        'monday' => $monday,
                                        'tuesday' => $tuesday,
                                        'wendsday' => $wendsday,
                                        'thursday' => $thursday,
                                        'friday'=> $friday,
                                        'saturday' => $saturday,
                                        'sunday' => $sunday,
                                        'limit_event' => $limit_event,//#Agrega el checkbox para limitar eventos por casa
                                        'cost' => $request->cost,
                                        'days_reserve_stay' => $request->days_reserve_stay,
                                        'color' => $request->color,
                                        'ocult_area' => $ocult_area,
                                        'cant_casas' => $request->cant_casas,
                                        'limit_aforo' => $request->limit_aforo,
                                        'limit_asist' => $request->limit_asist,
                                    ]); 

                                }
                            }
                        
                        }
                        else
                        {
                            $socialArea->update([

                                    'name_social_area' => $request->name_social_area,
                                    'monday' => $monday,
                                    'tuesday' => $tuesday,
                                    'wendsday' => $wendsday,
                                    'thursday' => $thursday,
                                    'friday'=> $friday,
                                    'saturday' => $saturday,
                                    'sunday' => $sunday,
                                    'limit_event' => $limit_event,//#Agrega el checkbox para limitar eventos por casa
                                    'cost' => $request->cost,
                                    'days_reserve_stay' => $request->days_reserve_stay,
                                    'color' => $request->color,
                                    'ocult_area' => $ocult_area,
                                    'cant_casas' => $request->cant_casas,
                                    'limit_aforo' => $request->limit_aforo,
                                    'limit_asist' => $request->limit_asist,
                                ]); 
                        }
                    }/*else{
                        $CantC = $request->cant_casas;
                        $CantA = $request->limit_asist;
                        $CantAf = $request->limit_aforo;
                        $errors = ['error' => "El producto de la cantidad de casas que pueden rentar un area social y la cantidad de asistentes por residencia es mayor que la cantidad de aforo: ( ({$CantC} * {$CantA}) > {$CantAf} )."];
                                      return redirect()->back()
                                          ->withErrors($errors);
                    }*/
                    return redirect('/configuration/social_areas');
                }
                else
                {
                    return redirect('/home');
                }

        } catch (\Illuminate\Database\QueryException $e) {
             
           /*$errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
          
                
        } catch (\Exception $e) {
        
            /*$errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
           
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\SocialArea  $socialArea
     * @return \Illuminate\Http\Response
     */
    public function destroy(SocialArea $socialArea, Request $request)
    {

        try{
             
            $user = Auth::user();
            $sarea = SocialArea::findOrfail($request->id);
            if($user->can('delete', $socialArea))
            {
                
               
                $sarea->delete();
                return redirect('/configuration/social_areas');
            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
