<?php

namespace App\Http\Controllers;

use App\Street;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Rol;
use App\View;
use App\Permission;
use Session;
use App\IncomeCategory;
use App\Admin;
use App\AccountReceivable;
use DB;
use App\Package;
use App\Payment;
use App\Status;
use Validator;
use App\Config;
use Carbon\Carbon;
use App\PaymentAccountReceivable;
use App\MonthlyContribution;


class StreetController extends Controller
{
    

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        
        $user = Auth::user();
      
        if($user->can('index', \App\Street::class))
        {
            /*DB::raw('SUM(to_pay) as pay'), 
        	 ->where('accounts_receivables.estatus','!=',$status2->id)
           ->groupBy('accounts_receivables.residence')*/
           $filtro = $request->input('streetnumber');
           $status = Status::where('name','activo')->first();
           $status2 = Status::where('name','cancelado')->first();


           $street = Street::leftjoin('accounts_receivables','residence','=','streets.id')
            ->leftjoin('payments','payments.residence','=','streets.id')
            ->leftjoin(DB::raw('(SELECT SUM(to_pay) as saldo,residence  FROM accounts_receivables WHERE estatus = "'.$status->id.'"  GROUP BY accounts_receivables.residence) as total'),'accounts_receivables.residence','=','total.residence')
            ->leftjoin(DB::raw('(SELECT  pago,SUM(amount) as monto,residence FROM `payments` LEFT JOIN (SELECT sum(paid) as pago, id_payment FROM payments_account_receivables GROUP BY id_payment) as adelantado ON payments.id = adelantado.id_payment WHERE status = "10" GROUP BY residence) as pagoadelantado'),'streets.id','=','pagoadelantado.residence')
            ->select('name_street', 'number','streets.id','pago','monto','accounts_receivables.id as aid','initial_debt','to_pay','debt','estatus','saldo','payments.id as payid','type','amount')
            ->where('empty_residence',0)
            ->when($filtro, function ($query) use ($filtro) {
                    
              return $query->where('streets.id',$filtro);   
                    
            })
            ->groupby('streets.id')
            ->orderby('name_street','ASC')
            ->orderby('number','ASC')
            ->paginate(15);
            
         
            
           $a = 0;
           $b = 0;

          if($request->abierto == 1)
          {
              $abierto = 1;
          }
          else
          {
              $abierto = 0;
          }


          
        return view('configuration.streets.index', compact('street','a','b','debt','abierto'));


        }
        else
        {
            return redirect()->back();
        }
       
    }

    public function create()
    {
      $user = Auth::user();
      if($user->can('create', \App\Street::class ))
      {
    	 return view('configuration.streets.create');
      }
      else
      {
          return redirect()->back();
      }
    }

    public function store(Request $request)
    {
    	
    	try{

        $messages = [

            'required'  => 'Este campo es requerido.',
            
        ];

        $rules = [

            'name_street' => 'required',
            'number'      => 'required',
            'debt'        => 'required',

          
        ];

        $validator = Validator::make($request->all(),$rules,$messages);

        if ($validator->fails()) {
            
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        else
        {
            

            DB::beginTransaction();

            $config = Config::first();

            
            if($config->multiple_contributions == 1)
            {
                $month = MonthlyContribution::where('asign',1)->first();
            
                if(is_null($month))
                {
                    $month = MonthlyContribution::first();
                }

            }
            else
            {
                $m = MonthlyContribution::where('asign',1)->first();
            
                if(is_null($m))
                {
                    $month = MonthlyContribution::first();
                }
                else
                {
                    $month = $m;
                }
                
                
            }
            
           

            for ($i=0; $i < count($request->number); $i++)
            {

                $package = Package::where('active_package',1)->first();

                $users = $package->total_users;

                $street = Street::where('empty_residence',0)->get();

                $num = count($street);
            

                if($num >= $users)
                {
                    if($num < $users)
                    {
                      $errors = ['casa' => 'Solo puedes registrar '.$num.' residencias'];
                      return redirect()->back()
                        ->withErrors($errors)
                         ->withInput();
                    }
                    else
                    {
                      $errors = ['casa' => 'Has llegado al limite de residencias por registrar.'];
                      return redirect()->back()
                        ->withErrors($errors)
                         ->withInput();
                    }
                    
                }

                 

                $street = Street::create([
                  'name_street' => strtolower($request->name_street),
                  'number' => $request->number[$i],
                  'contribution' => $month->id,

                ]);  


                if($request->debt[$i] >= 0)
                {
                    // type 2 //
                    $category = IncomeCategory::where('name','monthly')->first();
                    $actual_month = Admin::getActualMonth();
                    $config = Config::find(1);
                    $day = $config->days_to_be_debtor;
                    $status = Status::where('name','activo')->first();
                    $status2 = Status::where('name','')->first();
                    $fecha = Carbon::now();

                    $d = $fecha->toDateString();

                    $nuevafecha = strtotime ( '+'.$day.'days' , strtotime ($fecha->toDateString()));
                    $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                    
                   
                    $account = AccountReceivable::create([

                      'category' => $category->id,
                      'debt'     => $request->debt[$i],
                      'to_pay'   => $request->debt[$i],
                      'month'    => $actual_month->id,
                      'residence' => $street->id,
                      'deadline'  => $nuevafecha,
                      'estatus'   => $status->id,
                      'description' => 'Saldo inicial',

                    ]);
                   
                    

                    $st = Street::findOrfail($street->id);
                    $st->update([

                      'initial_debt' => $account->id,
                      'type'         => 2,

                    ]);
                }
                else
                {
                    $actual_month = Admin::getActualMonth();
                    $status = Status::where('name','adelantado')->first();
                    $fecha= Carbon::now();
                    $total = (-1)*($request->debt[$i]);
                    $pay = Payment::create([

                      'amount'        => $total,
                      'description'   => 'Saldo inicial',
                      'residence'     => $street->id,
                      'capture_date'  => $fecha->toDateString(),
                      'payment_date'  => $fecha->toDateString(),
                      'payment_type'  => 3,
                      'month'         => $actual_month->id,
                      'status'        => $status->id,
                             
                    ]);

                     $st = Street::findOrfail($street->id);
                    $st->update([

                      'initial_debt' => $pay->id,
                      'type'         =>1,

                    ]);

                                
                    

                }
                
                      
            }
            
            DB::commit();
        
           return redirect()->action('StreetController@index', ['abierto' => "1"]);
        }

      } catch (\Illuminate\Database\QueryException $e) {
             
        $errors = ['error' => 'Estas intentando agregar una residencia ya existente.'];
                return redirect()->back()
                    ->withErrors($errors)
                    ->withInput();

                 
                    
                
      } catch (\Exception $e) {
    
        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                return redirect()->back()
                    ->withErrors($errors)
                    ->withInput();

                  
                   
      }


    }

    public function edit($id)
    {
    	
      try{

            $street = Street::findOrfail($id);
            $user = Auth::user();
            if($user->can('edit', $street))
            {
              $street_edit = Street::findOrfail($id);

              if($street_edit->type == 2)
              { 
                  $debt = AccountReceivable::findOrfail($street_edit->initial_debt);
                  $status = Status::where('name',"aprobado")->first();
                  $type = 2;

                    $payment = Payment::where('residence',$street_edit->id)->where('status',$status->id)->get();

                    if($payment->isEmpty())
                    {
                        $pay = 1;
                    }
                    else
                    {
                        $pay = 0;
                    }
                    return view('configuration.streets.edit', compact('street_edit','debt','pay','type'));
              }
              else
              {

                  $debt = Payment::findOrfail($street_edit->initial_debt);
                  $cuentas = PaymentAccountReceivable::where('id_payment',$street_edit->initial_debt)->get();
                  $type = 1;
                  if($cuentas->isEmpty())
                  {
                      $pay = 1;
                  }
                  else
                  {
                    $pay = 0;
                  }

                  return view('configuration.streets.edit', compact('street_edit','debt','pay','type'));

              }
              
              
              
            }
            else
            {
                return redirect('home');
            }

      } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }

    }




    public function update(Request $request, $id)
    {
     
      
    	try{

          $messages = [

            'required'  => 'Este campo es requerido.',
            
          ];

         
            $rules = [

              'name_street' => 'required',
              'number'      => 'required',
            ];
          
          
          $validator = Validator::make($request->all(),$rules,$messages);

          if ($validator->fails()) {
              
              return redirect()->back()
                  ->withErrors($validator)
                  ->withInput();
          }
          else
          {
         

            $street = Street::findOrfail($id);
            $user = Auth::user();
            if($user->can('update', $street))
            {

              DB::beginTransaction();
              
                $street_update = Street::findOrfail($id);
              	$street_update->update([

              		'name_street' => $request->name_street, 
              		'number' => $request->number,
              	]);

                $debt = $request->input('debt');
                if(!is_null($debt))
                {
                    if($request->debt < 0)
                    {
                        
                        

                        
                            $total = (-1)*($request->debt);
                            if($street_update->type == 1)
                            {

                                $cuentas = PaymentAccountReceivable::where('id_payment',$street_update->initial_debt)->get();
                                if($cuentas->isEmpty())
                                {
                                    $pay = Payment::findOrfail($street_update->initial_debt);
                                    $pay->update([
                                          
                                        'amount'    => $total,

                                    ]);
                                }
                            }
                            else
                            {

                                $account = AccountReceivable::findOrfail($street_update->initial_debt);
                                $account->forceDelete();

                                $actual_month = Admin::getActualMonth();
                                $status = Status::where('name','adelantado')->first();
                                $fecha= Carbon::now();
                                $pay = Payment::create([

                                    'amount'        => $total,
                                    'description'   => 'Saldo inicial',
                                    'residence'     => $id,
                                    'capture_date'  => $fecha->toDateString(),
                                    'payment_date'  => $fecha->toDateString(),
                                    'payment_type'  => 3,
                                    'month'         => $actual_month->id,
                                    'status'        => $status->id,
                                             
                                ]);



                                   
                                $street_update->update([

                                  'initial_debt' => $pay->id,
                                  'type'         => 1,

                                ]);



                              }

                        
                            
                        
                    }
                    elseif($request->debt >= 0)
                    {
                           
                            if($street_update->type == 2)
                            {

                                $status = Status::where('name',"aprobado")->first();
                                $payment = Payment::where('residence',$street_update->id)->where('status',$status->id)->get();

                                if($payment->isEmpty())
                                {
                                    $account = AccountReceivable::findOrfail($street_update->initial_debt);

                                    $account->update([
                                          
                                        'debt'    => $request->debt,
                                        'to_pay'  => $request->debt,

                                    ]);
                                }

                            }
                            else
                            {
                                
                                $pay = Payment::findOrfail($street_update->initial_debt);
                                $pay->forceDelete();

                                $category = IncomeCategory::where('name','monthly')->first();
                                $actual_month = Admin::getActualMonth();
                                $config = Config::find(1);
                                $day = $config->days_to_be_debtor;
                                $status = Status::where('name','activo')->first();
                                $status2 = Status::where('name','')->first();
                                $fecha = Carbon::now();

                                $d = $fecha->toDateString();

                                $nuevafecha = strtotime ( '+'.$day.'days' , strtotime ($fecha->toDateString()));
                                $nuevafecha = date ( 'Y-m-j' , $nuevafecha );
                                    
                                   
                                $account = AccountReceivable::create([

                                  'category' => $category->id,
                                  'debt'     => $request->debt,
                                  'to_pay'   => $request->debt,
                                  'month'    => $actual_month->id,
                                  'residence' => $id,
                                  'deadline'  => $nuevafecha,
                                  'estatus'   => $status->id,
                                  'description' => 'Saldo inicial',

                                ]);
                                   

                                $street_update->update([

                                  'initial_debt' => $account->id,
                                  'type'         => 2,

                                ]);
                                


                            }
                                
                        

                            
                        
                        
                    }
                }
                
               
                  
              
                

              DB::commit();

              	return redirect('/configuration/streets');
            }
            else
            {
                return redirect()->back();
            }
          }
      } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Estas intentando agregar una residencia ya existente.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
          $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
             //throw $e;
        }


    }



   	public function destroy(Request $request)
   	{

      
      try{

            $street = Street::findOrfail($request->id);
            $user = Auth::user();
            /*if($user->can('delete', $street))
            {*/ 
                $user = User::where('street_id',$street->id)->first();
                if(empty($user) || is_null($user))
                {

                }
                else
                {
                   $user->update([

                    'street_id' => null,
                  ]);
                }
               
                $street->delete();

             		return redirect('/configuration/streets');
            /*}
            else
            {
                return redirect()->back();
            }*/
      } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
   	}

   	public function show($id)
   	{

   	}
}
