<?php

namespace App\Http\Controllers;

use App\SupportForm;
use Illuminate\Http\Request;
use Session;
use Auth;
use Illuminate\Support\Facades\Mail;
use App\Mail\SuportForm;
use Validator;

class SupportFormController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();

        if ($user->can('index', \App\SupportForm::class)) {
            return view('configuration.support_forms.create');
        } else {
            return redirect()->back();
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {

            $messages = [
                'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'name_support'      => 'required',
                'email_support'     => 'required',
                'phone_support'     => 'required',
                'message_support'   => 'required',

            ];

            $validator = Validator::make($request->all(), $rules, $messages);

            if ($validator->fails()) {

                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            } else {

                $suport = SupportForm::create([
                    'name_support' => $request->name_support,
                    'email_support' => $request->email_support,
                    'phone_support' => $request->phone_support,
                    'message_support' => $request->message_support,
                ]);


                Mail::to('soporte@innovationti.mx')->send(new SuportForm($suport));


                Session::flash('message', 'Se ha enviado correctamente tu mensaje.');
                return redirect('/configuration/support_form');
            }
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\SupportForm  $supportForm
     * @return \Illuminate\Http\Response
     */
    public function show(SupportForm $supportForm)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\SupportForm  $supportForm
     * @return \Illuminate\Http\Response
     */
    public function edit(SupportForm $supportForm)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\SupportForm  $supportForm
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SupportForm $supportForm)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\SupportForm  $supportForm
     * @return \Illuminate\Http\Response
     */
    public function destroy(SupportForm $supportForm)
    {
        //
    }
}
