<?php

namespace App\Http\Controllers;

use App\TransferAccount;
use Illuminate\Http\Request;
use App\Account;
use DB;
use Validator;

class TransferAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            $messages = [
                'required'    => 'Este campo es requerido.',
                'min'      => 'No puede ser 0.',
               
            ];

            $rules = [

                'source_account'        => 'required',
                'destination_account'   => 'required',
                'description2'           => 'required',
                'date'                  => 'required',
                'amount'                => 'required|min:0',

            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
               
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                    DB::beginTransaction();

                        TransferAccount::create([

                            'source_account'        => $request->source_account,
                            'destination_account'   => $request->destination_account,
                            'description'           => $request->description2,
                            'date'                  => $request->date,
                            'amount'                => $request->amount,
                        ]);

                        $t = $request->amount;

                        $source = Account::findOrfail($request->source_account);
                        $balance = $source->balance;
                        $total = $balance-$t;

                        if($t > $balance)
                        {
                            $errors =  ['amount' => 'La cantidad que quieres transferir es mayor a el saldo de la cuenta.'];
                            return redirect()->back()->withErrors($errors)->withInput();
                        }
                        
                        $source->update([

                            'balance' => $total,
                        ]);

                        $destination = Account::findOrfail($request->destination_account);
                        $balance2 = $destination->balance;
                        $total2 = $balance2+$t;

                        $destination->update([

                            'balance' => $total2,
                        ]);



                    DB::commit();

                    return redirect()->action('AccountController@index', ['abierto1' => "1"]);
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error3' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error3' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\TransferAccount  $transferAccount
     * @return \Illuminate\Http\Response
     */
    public function show(TransferAccount $transferAccount)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\TransferAccount  $transferAccount
     * @return \Illuminate\Http\Response
     */
    public function edit(TransferAccount $transferAccount)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\TransferAccount  $transferAccount
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TransferAccount $transferAccount)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TransferAccount  $transferAccount
     * @return \Illuminate\Http\Response
     */
    public function destroy(TransferAccount $transferAccount)
    {
        //
    }
}
