<?php

namespace App\Http\Controllers;

use App\IncomeResident;
use Illuminate\Http\Request;
use Auth;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use App\IncomeCategory;
use App\Street;
use App\PaymentType;
use App\Month;
use App\AccountInfo;
use Carbon\Carbon;
use App\Income;
use Session;

class UpdateIncomeResidentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function show(IncomeResident $incomeResident)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function edit(IncomeResident $incomeResident)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, IncomeResident $incomeResident,$id)
    {
        
        try{
                    $income = IncomeResident::findOrfail($id);

                    $user = Auth::user();

                    if($user->can('update', $income))
                    {
                            $fecha= Carbon::now();

                            if (Input::hasFile('file'))
                            {

                    	        $messages = [

                                        'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                                        'max'   => 'el archivo no debe pesar mas de 5 mb.',
                                ];

                                $rules = [

                                       'file' => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                                ];

                                $validator = Validator::make($request->all(),$rules,$messages);

                    	        if ($validator->fails()) {
                    	            return redirect()->back()
                    	                        ->withErrors($validator)
                    	                        ->withInput();
                    	        }
                    	        else
                    	        {
                    	            
                    	            $fileInput= Input::file('file');

                    	            
                    	                $fileName = $fileInput->getClientOriginalName();
                    	                $path = public_path().'/uploads/vouchers/';
                    	                $url = '/uploads/vouchers/';
                    	                $fileType = $fileInput->getMimeType();
                    	                $fileSize = $fileInput->getClientSize()/1024;
                                        $img = public_path().$income->url_voucher;

                    	                if($fileInput->move($path,$fileName))
                    	                {       
                    	                    $income->update([

                                                'category' => $request->category,
                                                'description' => $request->description,
                                                'quantity' => $request->quantity,
                                                'month' => $request->month,
                                                'residence'=> $request->residence,
                                                'accounting_date' => $request->accounting_date,
                                                'capture_date' => $fecha->toDateString(),
                                                'payment_type' => $request->payment_type,
                                                'voucher_name' =>$fileName,
                                                'url_voucher' => $url.$fileName,
                                                'voucher_type' => $fileType,
                                                'voucher_size' => $fileSize,
                                                'user_id' => Auth::id(),

                                            ]);
                                            
                                            unlink($img);
                    	                }
                    	            
                    	            

                    	            return redirect('/incomes');
                    	        }
                    	    }
                            else
                            {
                                    $income->update([

                                        'category' => $request->category,
                                        'description' => $request->description,
                                        'quantity' => $request->quantity,
                                        'month' => $request->month,
                                        'residence'=> $request->residence,
                                        'accounting_date' => $request->accounting_date,
                                        'capture_date' => $fecha->toDateString(),
                                        'payment_type' => $request->payment_type,
                                        'user_id' => Auth::id(),

                                    ]);

                                    return redirect('/incomes');

                            }
                    }
                    else
                    {
                        return redirect('/home');
                    }
                    
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function destroy(IncomeResident $incomeResident)
    {
        //
    }
}
