<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Validator;
use Auth;
use Illuminate\Support\Facades\Mail;
use App\Mail\ResidentRegister;
use App\Street;
use App\UserRole;
use App\PerfilConfig;
use DB;
use Session;
use App\Package;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Input;
use App\DomineColony;
use Illuminate\Contracts\Encryption\DecryptException;


class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        $id2 = Auth::user()->street_id;
      
        if($user->can('index', \App\User::class))
        {
            $filtro = $request->input('streetnumber');

            $resident = User::leftjoin('streets','street_id','=','streets.id')
                ->select('users.*','name_street','number')
                ->where('hidden',0)
                ->when($filtro, function ($query) use ($filtro) {
                    
                    return $query->where('streets.id',$filtro);   
                    
                })
                ->orderBy('name_street','ASC')
                ->orderBy('number','ASC')
                ->paginate(15);

            $a = 0;
           

            $st = Street::getStreetwithoutUser();
            if(empty($st))
            {
                $street = "";
            }
            else
            {
                $street = $st;
            }

            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }
            
            
            return view('configuration.residents.index', compact('id','resident','a','street','abierto'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
        if($user->can('create', \App\User::class ))
        {
            
            $street = Street::getStreetwithoutUser();

           
            return view('configuration.residents.create', compact('street'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        
        try{

            $messages = [
            'unique'    => 'El correo electrónico ya esta registrado.',
            'email'     => 'Debe ser un correo electrónico válido.',
            'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'email'         => 'unique:users,email|required|email', 
                'street_id'     => 'required',
                'name_resident' => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                    
                    DB::beginTransaction();

                   
                        $pass = str_random(8);
                        //$pass = 123456;


                        $user = User::create([

                            'name' => $request->name_resident,
                            'email' => $request->email,
                            'password' => bcrypt($pass),
                            'phone_resident' => $request->phone_resident,
                            'street_id' => $request->street_id,
                        ]);

                        $user->roles()->attach('2',['user_id'=> $user->id]);

                        PerfilConfig::create([

                            'user_id' => $user->id,
                            'private_profile' => 0,
                        ]);

                        $u = DomineColony::all();

                        foreach ($u as $us)
                        {
                            $url = $us->url;
                        }

                   
                     
                        Mail::to($request->email)->send(new ResidentRegister($user,$pass,$url));

                    
                        
                    

                    DB::commit();

                    $mensaje = 'Recuerda avisar al residente que revise el correo que registraste para que vea su constraseña.';
                    Session::flash('message', $mensaje ); 

                    return redirect()->action('UserController@index', ['abierto' => "1"]);
                }


        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
            
                
        } catch (\Exception $e) {
        
            $errors = ['error' =>  'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        
        $users = Auth::user();
        $id2 = Auth::user()->street_id;
        if($users->can('edit', $user))
        {
            
            $street = Street::getStreetwithoutUser();

            if(empty($user->street_id) || is_null($user->street_id))
            {
                $street_select = "";
            }
            else
            {
                $street_select = Street::findOrfail($user->street_id);
            }
            
            return view('configuration.residents.edit', compact('id2','street','user','street_select'));
        }
        else
        {
            return redirect('/home');
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $id2 = Auth::user()->street_id;
                
        if($id2 == 1){
            try{

                $messages = [
                    'unique'    => 'El correo electrónico ya esta registrado.',
                    'email'     => 'Debe ser un correo electrónico válido.',
                    'required'  => 'Este campo es requerido.',
                ];
    
                if($user->email == $request->email)
                {
                    $rules = [
                        'email'         => 'required|email', 
                        'name_resident' => 'required',
                    ];
                }
                else
                {
                    $rules = [
                        'email'         => 'unique:users,email|required|email', 
                        'name_resident' => 'required',
                    ];
                }
    
                $validator = Validator::make($request->all(),$rules,$messages);
    
                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
    
                    $u = Auth::user();
    
                    if($request->reservation_permission)
                    {
                        $reservation = 1;
                    }
                    else
                    {
                        $reservation = 0;
                    }
    
                    if($user->email == $request->email)
                    {
                                
                        $user->update([
                            'name' => $request->name_resident,
                            'email' => $request->email,
                            'phone_resident' => $request->phone_resident,
                            'reservation_permission' => $reservation,
                        ]);
    
                    }
                    else
                    {
                        $pass = str_random(8);
                                
                        $user->update([
                            
                            'name' => $request->name_resident,
                            'password' => bcrypt($pass),
                            'email' => $request->email,
                            'phone_resident' => $request->phone_resident,
                            'reservation_permission' => $reservation,
                        ]);
    
                        $u = DomineColony::all();
    
                        foreach ($u as $us)
                        {
                            $url = $us->url;
                        }
    
                        Mail::to($request->email)->send(new ResidentRegister($user,$pass,$url));
    
                    }
    
                    return redirect('configuration/users');
              
                }
    
            } catch (\Illuminate\Database\QueryException $e) {
                 
               $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
               return redirect()->back()
                  ->withErrors($errors);
                    
            } catch (\Exception $e) {
            
                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                return redirect()->back()
                  ->withErrors($errors);
            }
        }elseif($id2 != 1){
            try{

                $messages = [
                    'unique'    => 'El correo electrónico ya esta registrado.',
                    'email'     => 'Debe ser un correo electrónico válido.',
                    'required'  => 'Este campo es requerido.',
                ];
    
                if($user->email == $request->email)
                {
                    $rules = [
                        'email'         => 'required|email', 
                        'name_resident' => 'required',
                    ];
                }
                else
                {
                    $rules = [
                        'email'         => 'unique:users,email|required|email', 
                        'name_resident' => 'required',
                    ];
                }
    
                $validator = Validator::make($request->all(),$rules,$messages);
    
                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
    
                    $u = Auth::user();
    
                    if($request->reservation_permission)
                    {
                        $reservation = 1;
                    }
                    else
                    {
                        $reservation = 0;
                    }
    
                    if($user->email == $request->email)
                    {
                                
                        $user->update([
                            'name' => $request->name_resident,
                            'email' => $request->email,
                            'phone_resident' => $request->phone_resident,
                            'reservation_permission' => $reservation,
                        ]);
    
                    }
                    else
                    {
                        $pass = str_random(8);
                                
                        $user->update([
                            
                            'name' => $request->name_resident,
                            'password' => bcrypt($pass),
                            'email' => $request->email,
                            'phone_resident' => $request->phone_resident,
                            'reservation_permission' => $reservation,
                        ]);
    
                        $u = DomineColony::all();
    
                        foreach ($u as $us)
                        {
                            $url = $us->url;
                        }
    
                        Mail::to($request->email)->send(new ResidentRegister($user,$pass,$url));
    
                    }
    
                    return redirect('configuration/perfil_config');
              
                }
    
            } catch (\Illuminate\Database\QueryException $e) {
                 
               $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
               return redirect()->back()
                  ->withErrors($errors);
                    
            } catch (\Exception $e) {
            
                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                return redirect()->back()
                  ->withErrors($errors);
            }
        }
        try{

            $messages = [
                'unique'    => 'El correo electrónico ya esta registrado.',
                'email'     => 'Debe ser un correo electrónico válido.',
                'required'  => 'Este campo es requerido.',
            ];

            if($user->email == $request->email)
            {
                $rules = [
                    'email'         => 'required|email', 
                    'name_resident' => 'required',
                ];
            }
            else
            {
                $rules = [
                    'email'         => 'unique:users,email|required|email', 
                    'name_resident' => 'required',
                ];
            }

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                $u = Auth::user();

                if($request->reservation_permission)
                {
                    $reservation = 1;
                }
                else
                {
                    $reservation = 0;
                }

                if($user->email == $request->email)
                {
                            
                    $user->update([
                        'name' => $request->name_resident,
                        'email' => $request->email,
                        'phone_resident' => $request->phone_resident,
                        'reservation_permission' => $reservation,
                    ]);

                }
                else
                {
                    $pass = str_random(8);
                            
                    $user->update([
                        
                        'name' => $request->name_resident,
                        'password' => bcrypt($pass),
                        'email' => $request->email,
                        'phone_resident' => $request->phone_resident,
                        'reservation_permission' => $reservation,
                    ]);

                    $u = DomineColony::all();

                    foreach ($u as $us)
                    {
                        $url = $us->url;
                    }

                    Mail::to($request->email)->send(new ResidentRegister($user,$pass,$url));

                }

                return redirect('configuration/users');
          
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user,Request $request)
    {
    
        try{

            $users = Auth::user();

            if($users->can('delete', $user))
            {
               
                $user = User::findOrfail($request->id);
                $user->delete();
                $user = PerfilConfig::where('user_id', '=', $request->id)->firstOrFail();
                $user->delete();
                $user = UserRole::where('user_id', '=', $request->id)->firstOrFail();
                $user->delete();

                return redirect('configuration/users');
            }
            else
            {
                return redirect('/home');
            }
            
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    
}
