<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\RecurrentVisit;
use App\AccessType;
use App\AccessColony;
use App\Visit;
use Session;


class VisitCheckController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function store(Request $request)
    {
    	try{

            $date = Carbon::now();
            $visit = Visit::findOrfail($request->id);
            $recurrent = RecurrentVisit::where('visit_id',$request->id)->first();

            $recurrent->update([

                'check_in' => 1,
            ]);

            $type = AccessType::where('name',"visitante")->first();

            AccessColony::create([

                'date' => $date->toDateString(),
                'residence_id' => $visit->residence_id,
                'visit_id' => $visit->id,
                'type'   => $type->id,
                'check_in' => $date,

            ]);

            if($request->qr)
            {
                $mensaje = "Se guardo la entrada correctamente.";
                Session::flash('message2', $mensaje );
                return redirect()->action('DashboardGuardController@index');
            }
            else
            {
                $street = $request->backsearch;
                return redirect()->action('DashboardGuardController@index', ['street' => $street]);
            }
          
            
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
