<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IncomeResident extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'incomes_residents';

    protected $fillable = ['category',
						    'description',
						    'quantity',
						    'month',
						    'residence',
						    'accounting_date',
						    'capture_date',
                            'payment_type',
                            'voucher_name',
                            'url_voucher',
                            'voucher_type',
                            'voucher_size',
                            'user_id',
                            'check'];
}
