<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\LoginController;
use Illuminate\Http\Request;
use Carbon\Carbon;


class SuccessfulLogin
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param  Login  $event
     * @return void
     */
    public function handle(Login $event)
    {
        $login = LoginController::create([

            'user_id' => $event->user->id,
            'user_agent' =>  \Request::header('user-agent'),//$request->server('HTTP_USER_AGENT'),
            'last_login' => Carbon::now(),
        ]);
    }
}
