<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LogoColony extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'logo_colonies';
    protected $fillable = ['file_name', 'url_file', 'file_type', 'file_size'];

    public function getUrl()
    {
    	$l = LogoColony::findOrfail(1);

    	$logo = $l->url_file;

    	return $logo;
    }

}
