<?php

namespace App\Mail;

use App\User;
use App\Reservation;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Colony;

class DeleteReservation extends Mailable
{
    use Queueable, SerializesModels;
    public $user;
    public $reservation;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, Reservation $reservation)
    {
        $this->user = $user;
        $this->reservation = $reservation;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {
                $n_colonia = $colonies->colony_name;
            }
        }
        return $this->view('emails.deletereservation.delete')
            ->from('notificaciones@residenz.mx')
            ->subject('Reservación cancelada')
            ->with([
                'name' => $this->user->name,
                'title' => $this->reservation->title,
                'date' => $this->reservation->date,
                'start' => $this->reservation->time_start,
                'end' => $this->reservation->time_end,
                'n_colonia' => $n_colonia,

            ]);
    }
}
