<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Colony;

class EmailCharge extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, $total, $saldo)
    {
        $this->user = $user;
        $this->total = $total;
        $this->saldo = $saldo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {
                $n_colonia = $colonies->colony_name;
            }
        }

        return $this->view('emails.charge.chargenopay')
            ->from('notificaciones@residenz.mx')
            ->subject('Recargo')
            ->with([
                'name' => $this->user->name,
                'monto' => $this->total,
                'n_colonia' => $n_colonia,
                'saldo' => $this->saldo->deuda,


            ]);
    }
}
