<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class EmailDeadline extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($user, $saldo)
    {
        $this->user = $user;
        $this->saldo = $saldo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $actual_month = Admin::getActualMonth();
        $amount = MonthlyContribution::find(1);
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {
                $n_colonia = $colonies->colony_name;
            }
        }
        $account_type = AccountType::where('name', 'banco')->first();
        $account = Account::where('account_type', $account_type->id)->get();
        if (empty($account)) {
            $cuenta = "";
        } else {
            $cuenta = $account;
        }




        return $this->view('emails.reminderemail.reminder')
            ->from('notificaciones@residenz.mx')
            ->subject('Recordatorio de pago')
            ->with([
                'name' => $this->user->name,
                'aportacion' => $amount->amount,
                'saldo' => $this->saldo->deuda,
                'n_colonia' => $n_colonia,
                'account' => $cuenta,
                'mes'     => $actual_month->month_year_text,
                'pago'    => 0,
                'total'  => "",

            ]);
    }
}
