<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Payment;
use App\PaymentType;
use App\Admin;
use App\Colony;

class PayMail extends Mailable
{
    use Queueable, SerializesModels;
    public $user;
    public $payment;
    public $tipo_pago;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, Payment $payment, PaymentType $tipo_pago, $pago)
    {
        $this->user = $user;
        $this->payment = $payment;
        $this->tipo_pago = $tipo_pago;
        $this->pago = $pago;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $actual_month = Admin::getActualMonth();
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {
                $n_colonia = $colonies->colony_name;
            }
        }

        return $this->view('emails.pays.pay')
            ->from('notificaciones@residenz.mx')
            ->subject('Registro de pago')
            ->with([
                'name' => $this->user->name,
                'tipo_pago' => $this->tipo_pago->payment_name,
                'date' => $actual_month->month_year_text,
                'folio' => $this->payment->id,
                'amount' => $this->payment->amount,
                'n_colonia' => $n_colonia,
                'pago'  => $this->pago,

            ]);
    }
}
