<?php

namespace App\Mail;

use App\UserAccount;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Colony;

class ResidentCreate extends Mailable
{
    use Queueable, SerializesModels;
    public $user;
    public $pass;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(UserAccount $user, $pass, $url)
    {
        $this->user = $user;
        $this->pass = $pass;
        $this->url = $url;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {

                $n_colonia = $colonies->colony_name;
            }
        }
        return $this->view('emails.configuration.residentregister')
            ->from('notificaciones@residenz.mx')
            ->subject('Bienvenido a resindenz!')
            ->with([
                'name' => $this->user->name,
                'email' => $this->user->email,
                'password' => $this->pass,
                'n_colonia' => $n_colonia,
                'url'      => $this->url,
            ]);
    }
}
