<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\SupportForm;
use App\Colony;

class SuportForm extends Mailable
{
    use Queueable, SerializesModels;
    public $suport;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(SupportForm $suport)
    {
        $this->suport = $suport;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $colony = Colony::all();
        if ($colony->isEmpty()) {
            $n_colonia = "";
        } else {
            foreach ($colony as $colonies) {
                $n_colonia = $colonies->colony_name;
            }
        }
        return $this->view('emails.suportform.suport')
            ->from('notificaciones@residenz.mx')
            ->subject('Soporte Residenz')
            ->with([
                'name' => $this->suport->name_support,
                'phone' => $this->suport->phone_support,
                'email' => $this->suport->email_support,
                'me' => $this->suport->message_support,
                'n_colonia' => $n_colonia,

            ]);
    }
}
