<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use Auth;
use DB;
use App\Payment;
use App\AccountReceivable;
use App\Admin;
use App\Month;
use App\PaymentAccountReceivable;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use App\Report;
use App\Mail\PayMail;
use Illuminate\Support\Facades\Mail;
use App\Configs;

class Payment extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'payments';

    protected $fillable = [

		'amount',
        'description',
		'residence',
		'capture_date',
        'payment_date',
        'payment_type',
        'name_file',
        'url_file',
        'type_file',
        'size_file',
        'month',
        'description',
        'status',
        'reason_reject',
        'account_id',
       
    ];


    public static function createPay($request,$user)
    {

        if($user == 1)
        {
            $status = Status::where('name','confirmar')->first();
            $street = $request->residence;
            $debt = Report::getDebtResidentAdministratorWithoutEvents($request->residence);
            
            
        }
        else
        {
            $status = Status::where('name','confirmar')->first();
            $street = Auth::user()->street_id;
            $debt = Report::getDebtResidentAdministratorWithoutEvents(Auth::user()->street_id);
            
        }


        $fecha= Carbon::now();
        $actual_month = Admin::getActualMonth();


            if (Input::hasFile('file'))
            {
                
                $fileInput= Input::file('file');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);
                if($fileType == "image/jpeg")
                {
                    $type = "jpg";
                }
                else if($fileType == "application/pdf")
                {
                    $type = "pdf";
                }
                else if($fileType == "image/png")
                {
                    $type = "png";
                }

                if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                { 
                            
                    

                    if($request->imageData)
                    {
                        $data = base64_decode($request->imageData);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) 
                        {
                            
                               
                            $pay = Payment::create([
                                    
                                'amount'        => $request->amount,
                                'description'   => $request->description,
                                'residence'     => $street,
                                'capture_date'  => $fecha->toDateString(),
                                'payment_date'  => $request->payment_date,
                                'payment_type'  => $request->payment_type,
                                'month'         => $actual_month->id,
                                'status'        => $status->id,
                                
                            
                            ]);

                           

                            

                            $name_imagen = $pay->id.".".$type;
                            $url = '/uploads/vouchers/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData*1024;

                            $pay->update([

                                'name_file'     => $name_imagen,
                                'url_file'      => $url.$name_imagen,
                                'type_file'     => $request->contentType,
                                'size_file'     => $peso,
                            ]);

                            header('Content-Type: ',$request->contentData);
                            imagejpeg($im, $path);

                            imagedestroy($im);

                        }
                        else 
                        {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                        }
                    }
                    else 
                    {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                    }

                }
                else
                {
                    
                    $path = public_path().'/uploads/vouchers/';
                    $url = '/uploads/vouchers/';
                    $fileType = $fileInput->getMimeType();
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }

                    $fileSize = $fileInput->getClientSize()/1024;

                    

                          
                    $pay = Payment::create([
                                    
                        'amount'        => $request->amount,
                        'description'   => $request->description,
                        'residence'     => $street,
                        'capture_date'  => $fecha->toDateString(),
                        'payment_date'  => $request->payment_date,
                        'payment_type'  => $request->payment_type,
                        'month'         => $actual_month->id,
                        'status'        => $status->id,
                            
                    ]);

                    $fileName = $pay->id.".".$type;

                    if($fileInput->move($path,$fileName))
                    { 
                        $pay->update([

                            'name_file'     => $fileName,
                            'url_file'      => $url.$fileName,
                            'type_file'     => $fileType,
                            'size_file'     => $fileSize,
                        ]);      
                    }
                }
                  
            }
            else
            {
                $pay = Payment::create([

                    'amount'        => $request->amount,
                    'description'   => $request->description,
                    'residence'     => $street,
                    'capture_date'  => $fecha->toDateString(),
                    'payment_date'  => $request->payment_date,
                    'payment_type'  => $request->payment_type,
                    'month'         => $actual_month->id,
                    'status'        => $status->id,
                    
                ]);

                
            }

            
  
       

        return $pay->id;
    }

    public static function payAccount($residence,$amount,$pay)
    {

        $actual_month = Admin::getActualMonth();
        $status = Status::where('name','activo')->first();
        $account = AccountReceivable::where('residence',$residence)->where('to_pay','!=',0)->where('category','!=',3)->where('estatus',$status->id)->orderBy('month','ASC')->get();
        $e = $amount;
        foreach ($account as $accounts) 
        {

            $to_pay = $accounts->to_pay;

            if($e > $to_pay)
            {
                $e= $e-$to_pay;
                $t = 0;
                $i = $to_pay;

            }
            else
            {
                $t = $to_pay-$e;
                $i = $e;
                $e = $e-$to_pay;
               
            }

            //$r[] = $t;


            if($e > 0 || $t <= $to_pay)
            {
            
                $account = AccountReceivable::findOrFail($accounts->id);
                $olddebt = $account->to_pay; 
                $status = Status::where('name','pagado')->first();
                if($t == 0)
                {
                    $account->update([

                        'to_pay' => $t, 
                        'estatus' => $status->id,
                    ]);
                }
                else
                {
                    $account->update([

                        'to_pay' => $t, 
                    ]);
                }
                

                if($i > 0)
                {    
                    $payment = PaymentAccountReceivable::create([

                        'id_payment'               => $pay,
                        'id_account_receivables'   => $accounts->id,
                        'paid'                     => $i,
                        'new_debt'                 => $t,
                        'old_debt'                 => $olddebt,
                    ]);  
                } 

            }
        }

        $tipo = Payment::findOrFail($pay);


            $config = Config::all();
            foreach ($config as $configs) 
            {
                $send = $configs->send_mail;
            }

            if($send == 1)
            {
                $user = User::where('street_id',$tipo->residence)->first();
                if(is_null($user))
                {

                }
                else
                {
                    $tipo_pago = PaymentType::findOrFail($tipo->payment_type);
                    $pago = 0;
                    Mail::to($user->email)->send(new PayMail($user,$tipo,$tipo_pago,$pago));
                }
                
            }

        
    }

    public static function deletePayAccount($residence,$amount,$pay)
    {
        
        $actual_month = Admin::getActualMonth();

        $account = AccountReceivable::where('residence',$residence)->orderBy('month','ASC')->get();
        $e = $amount;
        foreach ($account as $accounts) 
        {

            $to_pay = $accounts->to_pay;

               


            
                $account = AccountReceivable::findOrFail($accounts->id);
                $account->update([

                    'to_pay' => $t, 
                ]);

                

            
        }

    }

    public static function getAccount($account)
    {
        $category = IncomeCategory::where('name','monthly')->first();
        $account = AccountReceivable::where('residence',$request->residence)->where('month',$account->month)->where('category',$category->id)->first();
        
        $pay = Payment::getAmountPay($request->amount,$accounts->to_pay);

        $amount = $pay;

    }

    public static function getAmountPay($amount,$topay,$id)
    {
        if($amount > $topay)
        {
            $amount = $amount-$topay;
            $topay = 0;
        }
        elseif($amount < $topay)
        {
            $topay = $topay-$amount;
            $amount = 0;
        }
        elseif($amount == $topay)
        {
            $topay = 0;
            $amount = 0;
        }

        return $amount;

    }

    public static function updatePay($request,$income)
    {
        $fecha= Carbon::now();

        $income->update([

            'amount'        => $request->amount,
            'residence'     => $request->residence,
            'capture_date'  => $fecha->toDateString(),
            'payment_type'  => $request->payment_type,
            'name_file'     => $request->name_file,
            'url_file'      => $request->url_file,
            'type_file'     => $request->type_file,
            'size_file'     => $request->size_file,
        ]);
    }

    public static function getIncomes()
    {
        $actual_month = Admin::getActualMonth();
        $last_month = $actual_month->id - 12;
        
        $month = Month::where('id','<=', $actual_month->id)->where('id','>=',$last_month)->get();

        $r = 0;
        foreach ($month as $months) 
        {
            $income = Payment::select(DB::raw('SUM(amount) as amount'))->where('month',$months->id)->get();

            foreach ($income as $incomes) {
                
                $c[] = array('month' => $months->id,'amount' => $incomes->amount);
            }
           
        }

        return $c;
        


    }
    
}
