<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'permissions';
    protected $fillable = ['name', 'display_name', 'description'];


    public function permissionRol()
    {
        return $this->belongsToMany('App\Rol')->withPivot('permission_id','view_id')->withTimestamps();
    }



    
}
