<?php

namespace App\Policies;

use App\User;
use App\Colony;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ColonyPolicy
{
    use HandlesAuthorization;

    
    /**
     * Determine whether the user can view the colony.
     *
     * @param  \App\User  $user
     * @param  \App\Colony  $colony
     * @return mixed
     */
    public function index(User $user)
    {
        
        $view_id = 2;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
      
        return $permission === 1;
    }

    public function view(User $user, Colony $colony)
    {
        
    }

    /**
     * Determine whether the user can create colonies.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 2;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 2;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the colony.
     *
     * @param  \App\User  $user
     * @param  \App\Colony  $colony
     * @return mixed
     */
    public function update(User $user, Colony $colony)
    {
        $view_id = 2;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the colony.
     *
     * @param  \App\User  $user
     * @param  \App\Colony  $colony
     * @return mixed
     */
    public function delete(User $user, Colony $colony)
    {
        $view_id = 2;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
