<?php

namespace App\Policies;

use App\User;
use App\Config;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ConfigPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        $view_id = 9;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the config.
     *
     * @param  \App\User  $user
     * @param  \App\Config  $config
     * @return mixed
     */
    public function view(User $user, Config $config)
    {
       
    }

    /**
     * Determine whether the user can create configs.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 9;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 9;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the config.
     *
     * @param  \App\User  $user
     * @param  \App\Config  $config
     * @return mixed
     */
    public function update(User $user, Config $config)
    {
        $view_id = 9;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the config.
     *
     * @param  \App\User  $user
     * @param  \App\Config  $config
     * @return mixed
     */
    public function delete(User $user, Config $config)
    {
        $view_id = 9;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
