<?php

namespace App\Policies;

use App\User;
use App\ExpenseCategory;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ExpenseCategoryPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $permission_id = Rol::checkRolPermission($user);
        $view_id = Rol::checkPermissionView($user);
        
        return $permission_id === 1 && $view_id === $view;
    }
    /**
     * Determine whether the user can view the expenseCategory.
     *
     * @param  \App\User  $user
     * @param  \App\ExpenseCategory  $expenseCategory
     * @return mixed
     */
    public function view(User $user, ExpenseCategory $expenseCategory)
    {
        $permission_id = Rol::checkRolPermission($user);
        $view_id = Rol::checkPermissionView($user);
        
        return $permission_id === 1 && $view_id === $view;
    }

    /**
     * Determine whether the user can create expenseCategories.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $permission_id = Rol::checkRolPermission($user);
        $view_id = Rol::checkPermissionView($user);
        
        return $permission_id === 1 && $view_id === $view;
    }

    /**
     * Determine whether the user can update the expenseCategory.
     *
     * @param  \App\User  $user
     * @param  \App\ExpenseCategory  $expenseCategory
     * @return mixed
     */
    public function update(User $user, ExpenseCategory $expenseCategory)
    {
        $permission_id = Rol::checkRolPermission($user);
        $view_id = Rol::checkPermissionView($user);
        
        return $permission_id === 1 && $view_id === $view;
    }

    /**
     * Determine whether the user can delete the expenseCategory.
     *
     * @param  \App\User  $user
     * @param  \App\ExpenseCategory  $expenseCategory
     * @return mixed
     */
    public function delete(User $user, ExpenseCategory $expenseCategory)
    {
        $permission_id = Rol::checkRolPermission($user);
        $view_id = Rol::checkPermissionView($user);
        
        return $permission_id === 1 && $view_id === $view;
    }
}
