<?php

namespace App\Policies;

use App\User;
use App\Expense;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ExpensePolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 17;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the expense.
     *
     * @param  \App\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function view(User $user, Expense $expense)
    {
        
    }

    /**
     * Determine whether the user can create expenses.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 17;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 17;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the expense.
     *
     * @param  \App\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function update(User $user, Expense $expense)
    {
        $view_id = 17;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the expense.
     *
     * @param  \App\User  $user
     * @param  \App\Expense  $expense
     * @return mixed
     */
    public function delete(User $user)
    {
        $view_id = 17;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
