<?php

namespace App\Policies;

use App\User;
use App\GuardInfo;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class GuardInfoPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 4;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the guardInfo.
     *
     * @param  \App\User  $user
     * @param  \App\GuardInfo  $guardInfo
     * @return mixed
     */
    public function view(User $user, GuardInfo $guardInfo)
    {
        
    }

    /**
     * Determine whether the user can create guardInfos.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 4;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 4;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the guardInfo.
     *
     * @param  \App\User  $user
     * @param  \App\GuardInfo  $guardInfo
     * @return mixed
     */
    public function update(User $user, GuardInfo $guardInfo)
    {
        $view_id = 4;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the guardInfo.
     *
     * @param  \App\User  $user
     * @param  \App\GuardInfo  $guardInfo
     * @return mixed
     */
    public function delete(User $user)
    {
        $view_id = 4;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
