<?php

namespace App\Policies;

use App\User;
use App\IncomeCategory;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class IncomeCategoryPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 4;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the incomeCategory.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeCategory  $incomeCategory
     * @return mixed
     */
    public function view(User $user, IncomeCategory $incomeCategory)
    {
        
    }

    /**
     * Determine whether the user can create incomeCategories.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 4;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can update the incomeCategory.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeCategory  $incomeCategory
     * @return mixed
     */
    public function update(User $user, IncomeCategory $incomeCategory)
    {
        $view_id = 4;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the incomeCategory.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeCategory  $incomeCategory
     * @return mixed
     */
    public function delete(User $user, IncomeCategory $incomeCategory)
    {
        $view_id = 4;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
