<?php

namespace App\Policies;

use App\User;
use App\IncomeResident;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class IncomeResidentPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view the incomeResident.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeResident  $incomeResident
     * @return mixed
     */
    public function index(User $user)
    {
        
        $view_id = 16;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }


    public function view(User $user, IncomeResident $incomeResident)
    {
       
    }

    /**
     * Determine whether the user can create incomeResidents.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 16;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 16;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the incomeResident.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeResident  $incomeResident
     * @return mixed
     */
    public function update(User $user)
    {
        $view_id = 16;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the incomeResident.
     *
     * @param  \App\User  $user
     * @param  \App\IncomeResident  $incomeResident
     * @return mixed
     */
    public function delete(User $user)
    {
        $view_id = 16;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
