<?php

namespace App\Policies;

use App\User;
use App\LogoColony;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class LogoColonyPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 13;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the logoColony.
     *
     * @param  \App\User  $user
     * @param  \App\LogoColony  $logoColony
     * @return mixed
     */
    public function view(User $user, LogoColony $logoColony)
    {
       
    }

    /**
     * Determine whether the user can create logoColonies.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 13;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 13;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the logoColony.
     *
     * @param  \App\User  $user
     * @param  \App\LogoColony  $logoColony
     * @return mixed
     */
    public function update(User $user, LogoColony $logoColony)
    {
        $view_id = 13;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the logoColony.
     *
     * @param  \App\User  $user
     * @param  \App\LogoColony  $logoColony
     * @return mixed
     */
    public function delete(User $user, LogoColony $logoColony)
    {
        $view_id = 13;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
