<?php

namespace App\Policies;

use App\User;
use App\PerfilConfig;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class PerfilConfigPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 7;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the perfilConfig.
     *
     * @param  \App\User  $user
     * @param  \App\PerfilConfig  $perfilConfig
     * @return mixed
     */
    public function view(User $user, PerfilConfig $perfilConfig)
    {
        
    }

    /**
     * Determine whether the user can create perfilConfigs.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 7;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 7;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the perfilConfig.
     *
     * @param  \App\User  $user
     * @param  \App\PerfilConfig  $perfilConfig
     * @return mixed
     */
    public function update(User $user, PerfilConfig $perfilConfig)
    {
        $view_id = 7;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the perfilConfig.
     *
     * @param  \App\User  $user
     * @param  \App\PerfilConfig  $perfilConfig
     * @return mixed
     */
    public function delete(User $user, PerfilConfig $perfilConfig)
    {
        $view_id = 7;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
