<?php

namespace App\Policies;

use App\User;
use App\Popup;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class PopupPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 14;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the popup.
     *
     * @param  \App\User  $user
     * @param  \App\Popup  $popup
     * @return mixed
     */
    public function view(User $user, Popup $popup)
    {
        
    }

    /**
     * Determine whether the user can create popups.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 14;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 14;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the popup.
     *
     * @param  \App\User  $user
     * @param  \App\Popup  $popup
     * @return mixed
     */
    public function update(User $user, Popup $popup)
    {
        $view_id = 14;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the popup.
     *
     * @param  \App\User  $user
     * @param  \App\Popup  $popup
     * @return mixed
     */
    public function delete(User $user, Popup $popup)
    {
        $view_id = 14;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
