<?php

namespace App\Policies;

use App\User;
use App\Reservation;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ReservationPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 23;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the reservation.
     *
     * @param  \App\User  $user
     * @param  \App\Reservation  $reservation
     * @return mixed
     */
    public function view(User $user, Reservation $reservation)
    {
        
    }

    /**
     * Determine whether the user can create reservations.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 23;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 23;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can update the reservation.
     *
     * @param  \App\User  $user
     * @param  \App\Reservation  $reservation
     * @return mixed
     */
    public function update(User $user, Reservation $reservation)
    {
        $view_id = 23;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the reservation.
     *
     * @param  \App\User  $user
     * @param  \App\Reservation  $reservation
     * @return mixed
     */
    public function delete(User $user, Reservation $reservation)
    {
        $view_id = 23;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
