<?php

namespace App\Policies;

use App\User;
use App\ReservationRes;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ReservationResPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 24;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the reservationRes.
     *
     * @param  \App\User  $user
     * @param  \App\ReservationRes  $reservationRes
     * @return mixed
     */
    public function view(User $user, ReservationRes $reservationRes)
    {
        //
    }

    /**
     * Determine whether the user can create reservationRes.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 24;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 24;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can update the reservationRes.
     *
     * @param  \App\User  $user
     * @param  \App\ReservationRes  $reservationRes
     * @return mixed
     */
    public function update(User $user)
    {
        $view_id = 24;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the reservationRes.
     *
     * @param  \App\User  $user
     * @param  \App\ReservationRes  $reservationRes
     * @return mixed
     */
    public function delete(User $user)
    {
        $view_id = 24;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
