<?php

namespace App\Policies;

use App\User;
use App\PermissionUser;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class ResidentPermissionPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 11;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the permissionUser.
     *
     * @param  \App\User  $user
     * @param  \App\PermissionUser  $permissionUser
     * @return mixed
     */
    public function view(User $user, PermissionUser $permissionUser)
    {
        //
    }

    /**
     * Determine whether the user can create permissionUsers.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    public function edit(User $user)
    {
        $view_id = 11;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the permissionUser.
     *
     * @param  \App\User  $user
     * @param  \App\PermissionUser  $permissionUser
     * @return mixed
     */
    public function update(User $user)
    {
        $view_id = 11;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the permissionUser.
     *
     * @param  \App\User  $user
     * @param  \App\PermissionUser  $permissionUser
     * @return mixed
     */
    public function delete(User $user, PermissionUser $permissionUser)
    {
        //
    }
}
