<?php

namespace App\Policies;

use App\User;
use App\Street;
use App\Rol;
use Auth;
use Illuminate\Auth\Access\HandlesAuthorization;

class StreetPolicy
{
    use HandlesAuthorization;

    

    /**
     * Determine whether the user can view the street.
     *
     * @param  \App\User  $user
     * @param  \App\Street  $street
     * @return mixed
     */
    public function index(User $user)
    {
        
        $view_id = 1;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }


    public function view(User $user, Street $street)
    {
        
        
        
    }

    /**
     * Determine whether the user can create streets.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {

        $view_id = 1;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    public function edit(User $user)
    {
        $view_id = 1;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the street.
     *
     * @param  \App\User  $user
     * @param  \App\Street  $street
     * @return mixed
     */
    public function update(User $user, Street $street)
    {
        $view_id = 1;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the street.
     *
     * @param  \App\User  $user
     * @param  \App\Street  $street
     * @return mixed
     */
    public function delete(User $user)
    {
        $view_id = 1;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
