<?php

namespace App\Policies;

use App\User;
use App\SupportForm;
use Illuminate\Auth\Access\HandlesAuthorization;
use App\Rol;

class SupportFormPolicy
{
    use HandlesAuthorization;

    public function index(User $user)
    {
        
        $view_id = 10;
        $permission_id = 1;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
    /**
     * Determine whether the user can view the supportForm.
     *
     * @param  \App\User  $user
     * @param  \App\SupportForm  $supportForm
     * @return mixed
     */
    public function view(User $user, SupportForm $supportForm)
    {
        //
    }

    /**
     * Determine whether the user can create supportForms.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        $view_id = 10;
        $permission_id = 2;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    public function edit(User $user)
    {
        $view_id = 10;
        $permission_id = 3;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
        
    }

    /**
     * Determine whether the user can update the supportForm.
     *
     * @param  \App\User  $user
     * @param  \App\SupportForm  $supportForm
     * @return mixed
     */
    public function update(User $user, SupportForm $supportForm)
    {
        $view_id = 10;
        $permission_id = 4;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }

    /**
     * Determine whether the user can delete the supportForm.
     *
     * @param  \App\User  $user
     * @param  \App\SupportForm  $supportForm
     * @return mixed
     */
    public function delete(User $user, SupportForm $supportForm)
    {
        $view_id = 10;
        $permission_id = 5;
        $permission = Rol::checkPermissionView($user,$view_id,$permission_id);
        
        return $permission === 1;
    }
}
