<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Colony;
use App\LogoColony;
use App\Rol;
use App\User;
use Auth;
use App\Street;
use App\Config;
use App\Status;
use DB;
use Carbon\Carbon;
use App\IncomeCategory;
use View;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        View::share('datesvalidation', 'pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$"');

        View::share('datesvalidation2', 'pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$"');

        
        view()->composer('colonyname', function($view){

            $view->with('name', Colony::all());
        });

        view()->composer('logocolony', function($view){
            
            $logo = LogoColony::find(1);
            $view->with('logo', $logo);
        });

        view()->composer('directaccess', function($view){
            
            $us = User::find(Auth::id());
            $rol = $us->belongsToMany('App\Rol')->wherePivot('user_id', Auth::id())->first();
            $rol_id = $rol->id;

            $admin = Rol::where('name', 'administrator')->first();
            $res = Rol::where('name','resident')->first();

            if($rol_id == $admin->id)
            {
                $rol = 1;
            }
            else
            {
                $rol = 2;
            }
            
            $view->with('rol', $rol);
        });

        view()->composer('streetname', function($view){
            
            $us = User::find(Auth::id());
            $rol = $us->belongsToMany('App\Rol')->wherePivot('user_id', Auth::id())->first();
            $rol_id = $rol->id;

            $admin = Rol::where('name', 'administrator')->first();
            $res = Rol::where('name','resident')->first();

            if($rol_id == $admin->id)
            {
                $street = "";
            }
            else
            {
                $street = Street::findOrfail(Auth::user()->street_id);
            }

            $view->with('street', $street);
        });

        view()->composer('master', function($view){
            
            if(Auth::id() == 2 || Auth::id() == 3)
            {
                $hide = 1;
            }
            else
            {
                $config = Config::all();
                foreach ($config as $configs) 
                {
                    $access_debtor = $configs->access_debtor;
                    $time = $configs->time_to_be_debtor;
                    $dias_credito = $configs->days_to_be_debtor;
                }

                if($access_debtor == 1)
                {
                    $date = Carbon::now();
                    $user = User::findOrfail(Auth::id());
                    $estatus = Status::where('name','activo')->first();

                    $mes_actual = date("m");

                    $category = IncomeCategory::where('name','monthly')->first();
                 
                    // #Cambio restriccion a moroso
                    $consulta = DB::select('select deadline,residence,MONTH(deadline) as limite,created_at FROM accounts_receivables WHERE  deadline < "'.$date->toDateString().'" AND estatus = "'.$estatus->id.'" AND residence = "'.$user->street_id.'" AND category = "'.$category->id.'" AND to_pay != 0');
                    

                    if(empty($consulta))
                    {
                        $hide = 1;
                    }
                    else
                    {
                        if($time == 0)
                        {
                            $hide = 1;
                        }
                        else
                        {
                            /*if($time == 1)
                            {
                                $hide = 0;
                            }
                            else
                            {
                                foreach ($consulta as $consultas) 
                                {
                                    
                                   
                                    
                                    $fechatreinta = strtotime ( '-'.$tiempo.' month' , strtotime ($date->toDateString()));
                                    $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );

                                    $fecha = explode("-", $fechatreinta);
                                    $mes = $fecha[1];

                                    
                                    if($consultas->limite <= $mes)
                                    {
                                        $s[]=0;
                                    }
                                    else
                                    {
                                        $s[]=1;
                                    }
                    
                                }

                         
                               foreach ($s as $ss) 
                                {
                                    if($ss == 0)
                                    {
                                        $hide = 0;
                                    }
                                    else
                                    {
                                        $hide = 1;
                                    }
                                }
                            }*/


                            $deudas = count($consulta);
                            if($deudas >= $time)
                            {
                                $hide = 0;
                            }
                            else
                            {
                                $hide = 1;
                            }
                        
                        }
                    }
                    
                    

                }
                else
                {
                    $hide = 1;
                }

                
            }

           
            
            $view->with('hide', $hide);
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
