<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
        'App\Street' => 'App\Policies\StreetPolicy',
        'App\User' => 'App\Policies\UserPolicy',
        'App\AccountInfo' => 'App\Policies\AccountInfoPolicy',
        'App\Colony' => 'App\Policies\ColonyPolicy',
        'App\Config' => 'App\Policies\ConfigPolicy',
        'App\EmailTemplate' => 'App\Policies\EmailTemplatePolicy',
        'App\GuardInfo' => 'App\Policies\GuardInfoPolicy',
        'App\LogoColony' => 'App\Policies\LogoColonyPolicy',
        'App\PerfilConfig' => 'App\Policies\PerfilConfigPolicy',
        'App\Popup' => 'App\Policies\PopupPolicy',
        'App\SocialArea' => 'App\Policies\SocialAreaPolicy',
        'App\SupportForm' => 'App\Policies\SupportFormPolicy',
        'App\Income' => 'App\Policies\IncomePolicy',
        'App\PermissionUser' => 'App\Policies\ResidentPermissionPolicy',
        'App\IncomeResident' => 'App\Policies\IncomeResidentPolicy',
        'App\Expense' => 'App\Policies\ExpensePolicy',
        'App\Message' => 'App\Policies\MessagePolicy',
        'App\MessageRes' => 'App\Policies\MessageResPolicy',
        'App\Directory' => 'App\Policies\DirectoryPolicy',
        'App\DocumentRes' => 'App\Policies\DocumentResPolicy',
        'App\Document' => 'App\Policies\DocumentPolicy',
        'App\Reservation' => 'App\Policies\ReservationPolicy',
        'App\ReservationRes' => 'App\Policies\ReservationResPolicy',
        'App\Configuration' => 'App\Policies\ConfigurationPolicy',
        'App\DirectoryAdmin' => 'App\Policies\DirectoryAdminPolicy',
        'App\Guard' => 'App\Policies\GuardPolicy',
        'App\Admin' => 'App\Policies\DashboardAdminPolicy',
        'App\Res' => 'App\Policies\DashboardResPolicy',
        'App\ReportAdmin' => 'App\Policies\ReportAdminPolicy',
        'App\ReportRes'  => 'App\Policies\ReportResPolicy',
        'App\Account'  => 'App\Policies\AccountPolicy',
        'App\LicenseSoftware'  => 'App\Policies\LicenseSoftwarePolicy',
        'App\AccessColony'  => 'App\Policies\AccessColonyPolicy'
        
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //
    }
}
