<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Income;
use App\Expense;
use App\ExpenseCategory;
use App\Payment;
use App\IncomeCategory;
use Auth;
use App\Account;
use App\PaymentAccountReceivable;
use App\Status;
use App\AccountToPay;
use App\Config;
use Carbon\Carbon;

class Report extends Model
{
    
    public static function getIncomesLastYear()
    {
    	
        $actual_month = Admin::getActualMonth();

        $n = $actual_month->id - 12;

        $month = Month::where('id','>=',$n)->where('id','<=',$actual_month->id)->get();
        $status = Status::where('name',"aprobado")->first();
        $status2 = Status::where('name',"adelantado")->first();
        foreach ($month as $months) 
        {

            $inicial = Street::join('payments','payments.id','=','initial_debt')
                ->where('type',1)
                ->where('status',$status2->id)
                ->where('month',$months->id)
                ->get();
            $inicio = $inicial->sum('amount');

            $income = Payment::where('month',$months->id)
                ->where(function ($query) use ($status,$status2){
                        $query->where('status',$status->id)
                              ->orWhere('status',$status2->id);
                    })
                ->get();

            $expense = Expense::where('month',$months->id)
            ->get();

            $e = $income->sum('amount');
            $s = $expense->sum('amount');

            $total = $e - $inicio;

            $r[] = array('month' => $months->month_year_text, 'amounti' => $total,'amounte' => $s);
        }

        return $r;

    }

    public static function getIncomeNumeral()
    {
        $status = Status::where('name',"aprobado")->first();
        $status2 = Status::where('name',"adelantado")->first();
        $actual_month = Admin::getActualMonth();

        

        $inicial = Street::join('payments','payments.id','=','initial_debt')
            ->where('payments.month',$actual_month->id)
            ->where('type',1)
            ->where('status',$status2->id)
            ->get();
        $e = $inicial->sum('amount');
        
        $income = Payment::where('payments.month',$actual_month->id)
            ->where(function ($query) use ($status,$status2){
                $query->where('status',$status->id)
                    ->orWhere('status',$status2->id);
            })
            ->get();

        $i = $income->sum('amount');

           
    	$total = $i-$e;
    	
    	return $total;
    }

    public static function getExpenseNumeral() 
    {
    	$actual_month = Admin::getActualMonth();
        $resident = Expense::where('month',$actual_month->id)->get();
    	$r = $resident->sum('amount');
    	return $r;
    }

    public static function getDebtResident()
    {
        $status = Status::where('name','activo')->first();
        $payment = AccountReceivable::where('residence', Auth::user()->street_id)->where('estatus',$status->id)->get();
        $e = $payment->sum('to_pay');
        return $e;
    }

    public static function getDebtResidentAdministrator($id)
    {
        $payment = AccountReceivable::where('residence', $id)->get();
        $e = $payment->sum('to_pay');
        return $e;
    }

    public static function getAllDebt()
    {
        $actual_month = Admin::getActualMonth();
        $status = Status::where('name','activo')->first();
        $payment = AccountReceivable::where('estatus',$status->id)->get();
        $e = $payment->sum('to_pay');
        return $e;
    }

    public static function getAllDebtResident()
    {
        

        /*$actual_month = Admin::getActualMonth();
        $n = $actual_month->id - 12;

        $debt = AccountReceivable::where('month','>=',$n)
            ->where('month','<=',$actual_month->id)
            ->get();
        

        $e = $debt->sum('to_pay');
        return $e;*/
        $date = Carbon::now();
        $type = IncomeCategory::where('name',"monthly")->first();
        $areas = IncomeCategory::where('name',"areas")->first();
        $status = Status::where('name','activo')->first();
        $account = AccountReceivable::where('estatus',$status->id)->where('to_pay','!=',0)->get();


        $total = 0;
        $total1 = 0;
        $total2 = 0;
        $total3 = 0;
        foreach ($account as $accounts) 
        {

            if($date->toDateString() <= $accounts->deadline)
            {
                $n = 0;
                $normales[] = $n + $accounts->to_pay;
                $suma1 = array_sum($normales);
                $total = $suma1;
              
            }
            else
            {
                 
                $fechatreinta = strtotime ( '-30 days' , strtotime ($date->toDateString()));
                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                


                $fechasesenta = strtotime ( '-60 days' , strtotime ($date->toDateString()));
                $fechasesenta  = date ( 'Y-m-d' , $fechasesenta );


               
                if($accounts->deadline >= $fechatreinta)
                {
                    $n = 0;
                    $uno[] = $n + $accounts->to_pay;
                    $total1 = array_sum($uno);
                }
                else if($accounts->deadline >= $fechasesenta && $accounts->deadline < $fechatreinta)
                {
                    $s = 0;
                    $dos[] = $s + $accounts->to_pay;
                    $total2 = array_sum($dos);
                }
                else 
                {
                    $t = 0;
                    $tres[] = $t + $accounts->to_pay;
                    $total3 = array_sum($tres);
                }
            }

        }


        $todo[] = array('normal' => $total, 'treinta' => $total1, 'sesenta' => $total2, 'mas' => $total3);
       
        return $todo;





    }

    public static function getAllDebtResident2()
    {
        

        $actual_month = Admin::getActualMonth();
        $n = $actual_month->id - 12;
        $status = Status::where('name','activo')->first();

        $debt = AccountReceivable::where('month','>=',$n)
            ->where('month','<=',$actual_month->id)
            ->where('estatus',$status->id)
            ->get();
        

        $e = $debt->sum('to_pay');
        return $e;
    }




    public static function getExpenseLastYear()
    {
    	$expense = Expense::where('month',$month)->get();
    	$e = $expense->sum('amount');
    	return $e;
    }

    public static function getExpensePerCategory()
    {
        $category = ExpenseCategory::all();
        $actual_month = Admin::getActualMonth();


        $n = $actual_month->id - 12;

        foreach ($category as $categories) 
        {
            //$expense = Expense::join('expense_categories','expense_categories.id','=','category')->where('month','>=',$n)->where('month','<=',$actual_month->id)->where('category',$categories->id)->get();
            $expense = Expense::join('expense_categories','expense_categories.id','=','category')->where('month',$actual_month->id)->where('category',$categories->id)->get();
            $e = $expense->sum('amount');
            $r[] = array('id' => $categories->id,'category_name' => $categories->category_name, 'amount' => $e);
        }

    	return $r;

    }

    public static function getExpensePerCategoryPorcentage()
    {
        $valores = Report::getExpensePerCategory();
        $actual_month = Admin::getActualMonth();
        $n = $actual_month->id - 12;
        //$expense = Expense::where('month','>=',$n)->where('month','<=',$actual_month->id)->get();
        $expense = Expense::where('month',$actual_month->id)->get();
        $e = $expense->sum('amount');

        if($e > 0)
        {
            foreach ($valores as $keys => $value) 
            {
                $exp = $valores[$keys]['amount'];
                $porcentaje = ($exp*100)/$e;
                $r[] = array('id' => $valores[$keys]['id'], 'category_name' => $valores[$keys]['category_name'], 'porcentage' => $porcentaje);
            }
        }
        else
        {
            foreach ($valores as $keys => $value) 
            {
                $exp = $valores[$keys]['amount'];
                $porcentaje = 0;
                $r[] = array('id' => $valores[$keys]['id'], 'category_name' => $valores[$keys]['category_name'], 'porcentage' => $porcentaje);
            }
        }
        
        

        return $r;
    }

    public static function getIncomesPerCategoryLastYear()
    {
        $category = IncomeCategory::all();
        $actual_month = Admin::getActualMonth();
        $status = Status::where('name',"aprobado")->first();
        $status2 = Status::where('name',"adelantado")->first();

        $n = $actual_month->id - 12;

 

        foreach ($category as $categories) 
        {


            $expense = PaymentAccountReceivable::join('accounts_receivables','id_account_receivables','=', 'accounts_receivables.id')
                ->leftjoin('payments','id_payment','=', 'payments.id')
                ->where('payments.month',$actual_month->id)
                ->where('category',$categories->id)
                ->where('status',$status->id)
                ->where('paid','!=',0)
                ->get();

            $e = $expense->sum('paid');


            $r[] = array('id' => $categories->id,'category_name' => $categories->category_name, 'amount' => $e);
        }

        return $r;

    }

    public static function payAdvanced()
    {
        $actual_month = Admin::getActualMonth();
        $status2 = Status::where('name',"adelantado")->first();


        $inicial = Street::join('payments','payments.id','=','initial_debt')
            ->where('payments.month',$actual_month->id)
            ->where('type',1)
            ->where('status',$status2->id)
            ->get();
        $e = $inicial->sum('amount');


        $pay = Payment::where('status',$status2->id)
            ->where('payments.month',$actual_month->id)
            ->get();
        $i = $pay->sum('amount');
        
        $total = $i-$e;
        return $total;

       
    }

    public static function getBalanceBank()
    {
        $account = Account::all();
        $e = $account->sum('balance');
        return $e;

        
    }

    public static function getallPay()
    {

        $actual_month = Admin::getActualMonth();
        $status = Status::where('name',"aprobado")->first();

        $n = $actual_month->id - 12;

        $pay = PaymentAccountReceivable::join('payments','id_payment','=', 'payments.id')
            ->where('payments.month','>=',$n)
            ->where('payments.month','<=',$actual_month->id)
            ->where('status',$status->id)
            ->get();

        $e = $pay->sum('paid');
        return $e;
    }

     public static function getIncomesPerCategoryLastYearTotal2()
    {
        
        $actual_month = Admin::getActualMonth();

        $n = $actual_month->id - 12;
        $status = Status::where('name',"aprobado")->first();
        $status2 = Status::where('name',"adelantado")->first();

        $inicial = Street::join('payments','payments.id','=','initial_debt')
            ->where('payments.month',$actual_month->id)
            ->where('type',1)
            ->where('status',$status2->id)
            ->get();
        $e = $inicial->sum('amount');

        $expense = Payment::where('payments.month',$actual_month->id)
            ->where(function ($query) use ($status,$status2){
                $query->where('status',$status->id)
                    ->orWhere('status',$status2->id);
            })
            ->get();

        $i = $expense->sum('amount');

        $total = $i - $e;

        return $total;

    }

    public static function getExpensePerCategoryLastYearTotal()
    {

        $actual_month = Admin::getActualMonth();

        $n = $actual_month->id - 12;

        /*$expense = Expense::where('month','>=',$n)
            ->where('month','<=',$actual_month->id)
            ->get();*/

        $expense = Expense::where('month',$actual_month->id)
            ->get();

        $e = $expense->sum('amount');

        return $e;

    }

    
    public static function getDebtResidentAdministratorWithoutEvents($id)
    {
        $status = Status::where('name','activo')->first();
        $category = IncomeCategory::where('name','areas')->first();
        $payment = AccountReceivable::where('residence', $id)->where('category','!=',$category->id)->where('estatus',$status->id)->get();
        $e = $payment->sum('to_pay');
        return $e;
    }

    public static function getAccountToPay()
    {
        $account = AccountToPay::all();
        $e = $account->sum('to_pay');
        return $e;
    }


    public static function getPays()
    {
        $status = Status::where('name',"adelantado")->first();
        $pay = Payment::where('status',$status->id)->where('residence',Auth::user()->street_id)->get();
        if($pay->isEmpty())
        {
            $total = " ";

            return $total;
        }
        foreach ($pay as $pays) 
        {
            $pagos = Payment::findOrfail($pays->id);
            $totalpagos = $pagos->amount;
            $monto = PaymentAccountReceivable::where('id_payment',$pays->id)->get();
            $montototal = $monto->sum('paid');

            if($totalpagos == $montototal)
            {
                $total[] = 0;
            }
            else
            {
                $total[] = $totalpagos - $montototal;
            }


        }

     
        if(empty($total))
        {
            $suma = 0;
        }
        else
        {

                $suma = 0;
                foreach ($total as $key => $totales) 
                {
                    $suma = $suma + $totales;
                }
            

            
        }


        
        
        return $suma;
    }

   
    
}
