<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use App\Mail\DeleteReservation;
use App\Status;
use App\Guest;

class Reservation extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    protected $table = 'reservations';

    protected $fillable = [	

        'residence_id',
    	'voucher_name',
    	'url_voucher',
    	'voucher_type',
    	'voucher_size',
    	'payment_type',
    	'cost',
    	'reservation_status',
        'date',
        'time_start',
        'time_end',
        'color',
        'title',
        'social_area',
        'limit_date',
        'cant_asist',
    ];


    public static function tiempoReserva()
    {

        try{

            DB::beginTransaction();

                $hoy = Carbon::now();
                $status1 = Status::where('name','pendiente')->first();
                $status3 = Status::where('name','confirmar')->first();
                $status2 = Status::where('name','cancelado')->first();
             
                $reservation = DB::table('reservations')
                    ->join('users', 'residence_id', '=','users.street_id')
                    ->join('social_areas', 'social_areas.id', '=', 'social_area')
                    ->leftjoin('payment_types', 'payment_type', '=', 'payment_types.id')
                    ->select('reservations.*','reservations.id as idreserv', 'users.name','payment_types.payment_name', 'social_areas.*','users.id as user_id','limit_date')
                    ->whereNull('reservations.deleted_at')
                    ->where('reservation_status',$status1->id)
                    ->orWhere('reservation_status',$status3->id)
                    ->distinct()
                    ->get();

                foreach ($reservation as $reservations) 
                {
                   
                    if($hoy->toDateString()  >  $reservations->limit_date)
                    {
                        $res = Reservation::findOrfail($reservations->idreserv);
                        $area = SocialArea::findOrfail($reservations->social_area);
                        $category = IncomeCategory::where('name','areas')->first();

                        if($reservations->date < $hoy->toDateString())
                        {

                        }
                        else
                        {
                            $guest = Guest::withTrashed()->where('reservation_id',$res->id)->get();
                            if($guest->isEmpty())
                            {
                                $t =  0;
                            }
                            else
                            {

                                $r = "";
                                foreach ($guest as $guests) 
                                {
                                    $acceso = AccessColony::select('id')->whereNotNull('check_in')->where('guest_id',$guests->id)->get();
                                    foreach ($acceso as $accesos) 
                                    {
                                        $r[] = $accesos->id;
                                    }
                                    
                                }

                                if(empty($r))
                                {
                                    $t =  0;
                                }
                                else
                                {
                                    $t =  1;
                                }
                            }

                            

                            if($t == 0)
                            {
                                $user_id = $reservations->user_id;
                                $user = User::findOrfail($user_id);
                                
                                $res->update([

                                    'reservation_status' => $status2->id,
                                ]);

                                $account = AccountReceivable::where('residence',$res->residence_id)->where('to_pay',$area->cost)->where('category',$category->id)->first();

                                if(empty($account))
                                {

                                }
                                else
                                {
                                    $account->update([

                                        'estatus' => $status2->id,
                                    ]);
                                    $account->delete();
                                }

                                Mail::to($user->email)->send(new DeleteReservation($user,$res));
                            }
                        }

                        
                    }
                }

            DB::commit();
        


        } catch (\Illuminate\Database\QueryException $e) {
             
            $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
            
            $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
            
        }

    }
}
