<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Resident extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    protected $table = 'residents';
    protected $fillable = ['name_resident','email_resident','phone_resident','street_id'];

    public function street_resident()
    {
        return $this->belongsTo('App\Street', 'street_id', 'id');
    }

    
}
