<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\Pivot;
use App\User;
use App\Rol;

class Rol extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'roles';
    protected $fillable = ['name','display_name', 'description'];


    public function userRol()
    {
        return $this->hasMany('App\User');
    }

    public function rolPermission()
    {
        return $this->belongsToMany('App\Permission')->withPivot('rol_id','view_id')->withTimestamps();
    }

    ////* función que verifica si el rol tiene el el permiso en al vista a la cual se quiere acceder.
    ////* parametros 
    ////* $user=  modelo del usuario
    ////* $view_id = id de la vista.
    ////* $permission_id = el id del permiso.
    ////* retorna 1 si el rol si tiene el permiso en al vista o 0 si el rol no tiene el permiso en al vista.
    public static function checkPermissionView($user,$view_id,$permission_id)
    {
        
        $us = User::find($user->id);
        
        $rol = $us->belongsToMany('App\Rol')->wherePivot('user_id', $user->id)->first();
        $rol_id = $rol->id;
        $p = Rol::find($rol_id);
        $permission = $p->rolPermission()->where('view_id',$view_id)->where('permission_id',$permission_id)->get();
        
        if($permission->isEmpty())
        {
            return 0;
        }
        else
        {
            return 1;
        }
        
    }

   
}
