<?php

namespace App;

use Laravel\Socialite\Contracts\User as ProviderUser;
use App\PerfilConfig;

class SocialAccountService
{
    public function createOrGetUser(ProviderUser $providerUser)
    {
        $account = SocialAccount::whereProvider('facebook')
            ->whereProviderUserId($providerUser->getId())
            ->first();

        if ($account) {
            return $account->user;
        } else {

            $account = new SocialAccount([
                'provider_user_id' => $providerUser->getId(),
                'provider' => 'facebook'
            ]);

            $user = User::whereEmail($providerUser->getEmail())->first();

            if (!$user) {

                $user = User::create([
                    'email' => $providerUser->getEmail(),
                    'name' => $providerUser->getName(),
                    'password' => bcrypt(str_random(16)),
                ]);
            }

            $account->user()->associate($user);
            $user->roles()->attach('1',['user_id'=> $user->id]);

            PerfilConfig::create([

                'user_id' => $user->id,
                'private_profile' => 1,
            ]);
            //$account->save();

            

            return $user;

        }

    }
}