<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\User;

class Street extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'streets';
    protected $fillable = ['name_street', 'number','initial_debt','type','contribution'];

    public function streetUser()
    {
        return $this->belongsTo('App\User');
    }

    public static function getStreets()
    {
        $street = Street::where('empty_residence',0)->get();
        return $street;
    }

    public static function getStreetwithoutUser()
    {
        $user = User::where('hidden',0)->where('street_id','!=',NULL)->get();

        if($user->isEmpty())
        {
            $s = "";
            
        }
        else
        {
            foreach ($user as $users) 
            {
                
                $s[] = $users->street_id;
            }
        }

        
        if(empty($s))
        {
            $sr= Street::where('empty_residence',0)->get();
        }
        else
        {
            $street = Street::where('empty_residence',0)->get();
      
            $sr[] = " ";
            if(empty($street))
            {
                $sr = "";
            }
            else
            {
                foreach ($street as $streets) 
                {
                    if(!in_array($streets->id,$s))
                    { 
                        $st = Street::find($streets->id);
                        $sr[] = $st;   
                    }   
                }
            }
        }
        

       
        return $sr;
        
    }

    public static function getStreetwithUser()
    {
        $user = User::where('hidden',0)->where('street_id','!=',NULL)->get();
        $s[] = ""; 
        foreach ($user as $users) 
        {
                
            $s[] = $users->street_id;
        }
        

        $street = Street::all();
        $sr[] = Street::where('empty_residence',1)->first();
        foreach ($street as $streets) 
        {
            if(in_array($streets->id,$s))
            { 
                $st = Street::find($streets->id);
                $sr[] = $st;   
            }   
        }

        return $sr;
    }

    public static function getAccountStreet($street_id)
    {

            
        
    }

    
}
