<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'phone_resident', 'street_id', 'active', 'debt_permission', 'reservation_permission', 'hidden'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'remember_token',
    ];

    public function roles()
    {
        return $this->belongsToMany('App\Rol')->withPivot('user_id', 'rol_user')->withTimestamps();
    }

    public function userPermission()
    {
        return $this->belongsToMany('App\Permission')->withPivot('user_id', 'permission_id')->withTimestamps();
    }

    public function userStreet()
    {
        return $this->hasOne('App\Street');
    }

    public function userPerfilConfig()
    {
        return $this->belongsTo('App\PerfilConfig');
    }

    public function userColony()
    {
        return $this->belongsTo('App\Colony');
    }
}
