<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Visit;
use Carbon\Carbon;
use Auth;
use Validator;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;

class Visit extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'visits';
    protected $fillable = [
    
    		'name',
    		'type',
    		'residence_id',
            'file_name',  
            'url_file',
            'file_size',
            'file_type',
    		
    ];


    public static function createVisit($request)
    {
   
        if($request->file)
        {
            if (Input::hasFile('file'))
            {

                $fileInput= Input::file('file');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);

                if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                { 
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }    

                
                    if($request->imageData)
                    {
                        $data = base64_decode($request->imageData);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) 
                        {
                            
                            
                            $fecha= Carbon::now();
                            $et = EmployeType::where('name',$request->visit_type)->first();

                            $visit = Visit::create([

                                'name'          => $request->name,
                                'type'          => $et->id,
                                'residence_id'  => Auth::user()->street_id,
                               

                            ]);

                            $name_imagen = $visit->id.".".$type;
                            $url = '/uploads/photos/visit/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData*1024;

                            $visit->update([

                                'file_name'     => $name_imagen,
                                'url_file'      => $url.$name_imagen,
                                'file_size'     => $peso,
                                'file_type'     => $request->contentType,
                            ]);

                            header('Content-Type: ',$request->contentData);
                            imagejpeg($im, $path);


                            if($request->visit_type == "recurrente")
                            {
                                if($request->monday){$monday = 1;}else{$monday = 0;}
                                if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                if($request->friday){$friday = 1;}else{$friday = 0;}
                                if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                $access_id_recurrent = RecurrentVisit::create([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,
                                    'visit_id'   => $visit->id,

                                ]);
                            }
                            else
                            {

                                $type = AccessType::where('name','visitante')->first();
                                $access_id = AccessColony::create([
                                                    
                                    'date'         => $request->date_start,
                                    'residence_id' => Auth::user()->street_id,
                                    'type'         => $type->id,
                                    'visit_id'     => $visit->id, 

                                ]);
                                                
                            }

                            imagedestroy($im);
                        }
                        else 
                        {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                        }
                    }
                    else 
                    {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                            ->withErrors($errors);
                    }

                }
                else
                {
                    $fileName = $clave.$fileInput->getClientOriginalName();
                    $path = public_path().'/uploads/photos/visit/';
                    $url = '/uploads/photos/visit/';
                    $fileType = $fileInput->getMimeType();
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }  
                    $fileSize = $fileInput->getClientSize()/1024;

                          
                        $fecha= Carbon::now();
                        $et = EmployeType::where('name',$request->visit_type)->first();

                        $visit = Visit::create([

                            'name'          => $request->name,
                            'type'          => $et->id,
                            'residence_id'  => Auth::user()->street_id,
                          

                        ]);

                        $fileName = $visit->id.".".$type;

                        if($fileInput->move($path,$fileName))
                        {
                            $visit->update([

                                'file_name'     => $fileName,
                                'url_file'      => $url.$fileName,
                                'file_size'     => $fileSize,
                                'file_type'     => $fileType,
                            ]);
                        }

                        if($request->visit_type == "recurrente")
                        {
                            if($request->monday){$monday = 1;}else{$monday = 0;}
                            if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                            if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                            if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                            if($request->friday){$friday = 1;}else{$friday = 0;}
                            if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                            if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                             $access_id_recurrent = RecurrentVisit::create([

                                'date_start' => $fecha->toDateString(),
                                'date_end'   => $request->date_end,
                                'monday'     => $monday,
                                'tuesday'    => $tuesday,
                                'wendsday'   => $wendsday,
                                'thursday'   => $thursday,
                                'friday'     => $friday,
                                'saturday'   => $saturday,
                                'sunday'     => $sunday,
                                'time_start' => $request->time_start,
                                'time_end'   => $request->time_end,
                                'visit_id'   => $visit->id,

                            ]);
                        }
                        else
                        {

                            $type = AccessType::where('name','visitante')->first();
                             $access_id = AccessColony::create([
                                                
                                'date'         => $request->date,
                                'residence_id' => Auth::user()->street_id,
                                'type'         => $type->id,
                                'visit_id'     => $visit->id, 

                            ]);
                                            
                        }
                    
                }
                    
            }
            if($request->visit_type == "recurrente")
            {
                return  $access_id_recurrent;
            }
            else
            {
                return  $access_id;
            }
        }
        else if($request->file1)
        {
            $fileInput1 = Input::file('file1');

            
            if (Input::hasFile('file1'))
            {

                $fileInput= Input::file('file1');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);

                if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                { 
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }  

                    

                    if($request->imageData2)
                    {
                        $data = base64_decode($request->imageData2);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) 
                        {
                            
                            
                            $fecha= Carbon::now();
                            $et = EmployeType::where('name',$request->visit_type)->first();

                            $visit = Visit::create([

                                'name'          => $request->name,
                                'type'          => $et->id,
                                'residence_id'  => Auth::user()->street_id,
                                

                            ]);

                            $name_imagen = $visit->id.".".$type;
                            $url = '/uploads/photos/visit/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData2*1024;

                            $visit->update([

                                'file_name'     => $name_imagen,
                                'url_file'      => $url.$name_imagen,
                                'file_size'     => $peso,
                                'file_type'     => $request->contentType2,
                            ]);

                            header('Content-Type: ',$request->contentData2);
                            imagejpeg($im, $path);



                            if($request->visit_type == "recurrente")
                            {
                                if($request->monday){$monday = 1;}else{$monday = 0;}
                                if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                if($request->friday){$friday = 1;}else{$friday = 0;}
                                if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                $access_id_recurrent = RecurrentVisit::create([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,
                                    'visit_id'   => $visit->id,

                                ]);
                            }
                            else
                            {

                                $type = AccessType::where('name','visitante')->first();
                                $access_id = AccessColony::create([
                                                    
                                    'date'         => $request->date,
                                    'residence_id' => Auth::user()->street_id,
                                    'type'         => $type->id,
                                    'visit_id'     => $visit->id, 

                                ]);
                                                
                            }

                            imagedestroy($im);
                        }
                        else 
                        {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                        }
                    }
                    else 
                    {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                            ->withErrors($errors);
                    }

                }
                else
                {
                    
                    $path = public_path().'/uploads/photos/visit/';
                    $url = '/uploads/photos/visit/';
                    $fileType = $fileInput1->getMimeType();
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }  
                    $fileSize = $fileInput1->getClientSize()/1024;

                           
                        $fecha= Carbon::now();
                        $et = EmployeType::where('name',$request->visit_type)->first();

                        $visit = Visit::create([

                            'name'          => $request->name,
                            'type'          => $et->id,
                            'residence_id'  => Auth::user()->street_id,
                            

                        ]);

                        $fileName = $visit->id.".".$type;

                        if($fileInput1->move($path,$fileName))
                        {
                            $visit->update([
                                'file_name'     => $fileName,
                                'url_file'      => $url.$fileName,
                                'file_size'     => $fileSize,
                                'file_type'     => $fileType,
                            ]);
                        }

                        if($request->visit_type == "recurrente")
                        {
                            if($request->monday){$monday = 1;}else{$monday = 0;}
                            if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                            if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                            if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                            if($request->friday){$friday = 1;}else{$friday = 0;}
                            if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                            if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                             $access_id_recurrent = RecurrentVisit::create([

                                'date_start' => $fecha->toDateString(),
                                'date_end'   => $request->date_end,
                                'monday'     => $monday,
                                'tuesday'    => $tuesday,
                                'wendsday'   => $wendsday,
                                'thursday'   => $thursday,
                                'friday'     => $friday,
                                'saturday'   => $saturday,
                                'sunday'     => $sunday,
                                'visit_id'   => $visit->id,

                            ]);
                        }
                        else
                        {

                            $type = AccessType::where('name','visitante')->first();
                            $access_id = AccessColony::create([
                                    
                                'date'         => $request->date,
                                'residence_id' => Auth::user()->street_id,
                                'type'         => $type->id,
                                'visit_id'     => $visit->id, 

                            ]);
                                
                        }

                            
                    
                }
    
            }

            if($request->visit_type == "recurrente")
            {
                return  $access_id_recurrent;
            }
            else
            {
                return  $access_id;
            }

                  
        }
        else
        {
            
            $fecha= Carbon::now();
            $et = EmployeType::where('name',$request->visit_type)->first();
                
            $visit = Visit::create([

                'name'          => $request->name,
                'type'          => $et->id,
                'residence_id'  => Auth::user()->street_id,

            ]);

            if($request->visit_type == "recurrente")
            {
                if($request->monday){$monday = 1;}else{$monday = 0;}
                if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                if($request->friday){$friday = 1;}else{$friday = 0;}
                if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                $access_id = RecurrentVisit::create([

                    'date_start' => $fecha->toDateString(),
                    'date_end'   => $request->date_end,
                    'monday'     => $monday,
                    'tuesday'    => $tuesday,
                    'wendsday'   => $wendsday,
                    'thursday'   => $thursday,
                    'friday'     => $friday,
                    'saturday'   => $saturday,
                    'sunday'     => $sunday,
                    'visit_id'   => $visit->id,

                ]);

                return $access_id;
            }
            else
            {

                $type = AccessType::where('name','visitante')->first();
                $access_id = AccessColony::create([
                                
                    'date'         => $request->date,
                    'residence_id' => Auth::user()->street_id,
                    'type'         => $type->id,
                    'visit_id'     => $visit->id, 

                ]);

                return $access_id;
                            
            }

            
        }
        
    }


    public static function updateVisit($request,$id)
    {
        
        $visit = Visit::findOrfail($id);
        $fecha= Carbon::now();

        if($request->file)
        {
           
            if(Input::hasFile('file'))
            {

                $fileInput= Input::file('file');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);

                if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                { 
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }    

                    $name_imagen = $visit->id.".".$type;
                    $url = '/uploads/photos/visit/';
                    $path = public_path().$url.$name_imagen;
                    $peso = $request->sizeData*1024;

                    if($request->imageData)
                    {
                        $data = base64_decode($request->imageData);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) 
                        {
                            header('Content-Type: ',$request->contentData);
                            imagejpeg($im, $path);
                            
                            if($request->visit_type == "recurrente")
                            {
                                $type = EmployeType::where('name',"recurrente")->first();
                                $type2 = $visit->type;

                                if($type2 == $type->id)
                                {
                                    if($request->monday){$monday = 1;}else{$monday = 0;}
                                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                    if($request->friday){$friday = 1;}else{$friday = 0;}
                                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);

                                    $recurrentvisit->update([

                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'visit_id'   => $visit->id,

                                    ]);

                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);
                                }
                                else
                                {
                                    
                                    if($request->monday){$monday = 1;}else{$monday = 0;}
                                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                    if($request->friday){$friday = 1;}else{$friday = 0;}
                                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                    RecurrentVisit::create([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'visit_id'   => $visit->id,

                                    ]);

                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                     ]);

                                   

          
                                }

                            }   
                            else
                            {

                                $type = EmployeType::where('name',"eventual")->first();
                                $type2 = $visit->type;

                                if($type2 == $type->id)
                                {
                                    $visit->update([

                                        'name'          => $request->name,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,
                                    ]);
                                }
                                else
                                {
                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);

                                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);
                                    $recurrentvisit->forceDelete();
                                }
                                    
                            }

                            imagedestroy($im);
                        }
                        else 
                        {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                        }
                    }
                    else 
                    {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                            ->withErrors($errors);
                    }

                }
               
                    
            }
            return 1;
        }
        else if($request->file1)
        {

            if (Input::hasFile('file1'))
            {
                
                $fileInput= Input::file('file1');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);

                if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                { 
                    if($fileType == "image/jpeg")
                    {
                        $type = "jpg";
                    }
                    else if($fileType == "application/pdf")
                    {
                        $type = "pdf";
                    }
                    else if($fileType == "image/png")
                    {
                        $type = "png";
                    }  

                    $name_imagen = $visit->id.".".$type;
                    $url = '/uploads/photos/';
                    $path = public_path().$url.$name_imagen;
                    $peso = $request->sizeData2*1024;

                    if($request->imageData2)
                    {
                        $data = base64_decode($request->imageData2);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) 
                        {
                            header('Content-Type: ',$request->contentData2);
                            imagejpeg($im, $path);
                            
                            if($request->visit_type == "recurrente")
                            {
                                $type = EmployeType::where('name',"recurrente")->first();
                                $type2 = $visit->type;

                                if($type2 == $type->id)
                                {
                                    if($request->monday){$monday = 1;}else{$monday = 0;}
                                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                    if($request->friday){$friday = 1;}else{$friday = 0;}
                                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);

                                    $recurrentvisit->update([

                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'visit_id'   => $visit->id,

                                    ]);

                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);
                                }
                                else
                                {
                                    
                                    if($request->monday){$monday = 1;}else{$monday = 0;}
                                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                                    if($request->friday){$friday = 1;}else{$friday = 0;}
                                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                                    RecurrentVisit::create([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'visit_id'   => $visit->id,

                                    ]);

                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                     ]);
          
                                    
                                    
                                }
                            }   
                            else
                            {

                                $type = EmployeType::where('name',"eventual")->first();
                                $type2 = $visit->type;
                                if($type2 == $type->id)
                                {
                                    $visit->update([

                                        'name'          => $request->name,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,
                                    ]);
                                }
                                else
                                {
                                    $visit->update([

                                        'name'          => $request->name,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url.$name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);

                                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);
                                    $recurrentvisit->forceDelete();
                                }
                                    
                            }

                            imagedestroy($im);
                        }
                        else 
                        {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                return redirect()->back()
                                ->withErrors($errors);
                        }
                    }
                    else 
                    {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                            ->withErrors($errors);
                    }

                }


    
            }

            return 1;      
        }
        else
        {
            
            if($request->visit_type == "recurrente")
            {
                $type = EmployeType::where('name',"recurrente")->first();
                $type2 = $visit->type;

                if($type2 == $type->id)
                {
                    if($request->monday){$monday = 1;}else{$monday = 0;}
                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                    if($request->friday){$friday = 1;}else{$friday = 0;}
                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                    
                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);
                    

                    $recurrentvisit->update([

                        'date_end'   => $request->date_end,
                        'monday'     => $monday,
                        'tuesday'    => $tuesday,
                        'wendsday'   => $wendsday,
                        'thursday'   => $thursday,
                        'friday'     => $friday,
                        'saturday'   => $saturday,
                        'sunday'     => $sunday,
                        'visit_id'   => $visit->id,

                    ]);

                    $visit->update([

                        'name'          => $request->name,
                        'type'          => $type->id,
                     

                    ]);
                }
                else
                {
                            
                    if($request->monday){$monday = 1;}else{$monday = 0;}
                    if($request->tuesday){$tuesday = 1;}else{$tuesday = 0;}
                    if($request->wendsday){$wendsday = 1;}else{$wendsday = 0;}
                    if($request->thursday){$thursday = 1;}else{$thursday = 0;}
                    if($request->friday){$friday = 1;}else{$friday = 0;}
                    if($request->saturday){$saturday = 1;}else{$saturday = 0;}
                    if($request->sunday){$sunday = 1;}else{$sunday = 0;}

                    RecurrentVisit::create([

                        'date_start' => $fecha->toDateString(),
                        'date_end'   => $request->date_end,
                        'monday'     => $monday,
                        'tuesday'    => $tuesday,
                        'wendsday'   => $wendsday,
                        'thursday'   => $thursday,
                        'friday'     => $friday,
                        'saturday'   => $saturday,
                        'sunday'     => $sunday,
                        'visit_id'   => $visit->id,

                    ]);

                    $visit->update([

                        'name'          => $request->name,
                        'type'          => $type->id,
                      

                    ]);
  
                }
                            
            }
            else
            {

                $type = EmployeType::where('name',"eventual")->first();
                $type2 = $visit->type;

                if($type2 == $type->id)
                {
                    $visit->update([

                        'name'          => $request->name,
                        
                       
                    ]);
                }
                else
                {
                    $visit->update([

                        'name'          => $request->name,
                        'type'          => $type->id,
                    
                    ]);

                    $recurrentvisit = RecurrentVisit::where('visit_id',$id);
                    $recurrentvisit->forceDelete();
                }
                            
            } 
           
        }
    }



    public static function cortar($data)
    {
        $tamano = strlen ($data);

        $posicion = strpos($data, '/');

        $parte = $tamano - $posicion;

        $dato = substr($data, 0, -$parte);

        return $dato;
        
    }

    public static function cortar2($data)
    {
        $tamano = strlen ($data);
        $posicion = strpos($data, '/');
        $parte = $posicion + 1;
        $parte2 = -($posicion - $tamano);
        $dato = substr($data, $parte, $parte2);
               
        return $dato;
        
    }
  
}
