<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStreets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('streets', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name_street',30);
            $table->string('number',8);
            $table->integer('initial_debt')->unsigned()->index();
            $table->foreign('initial_debt')->references('id')->on('accounts_receivables')->onDelete('cascade');
            $table->unique(['name_street', 'number']);
            $table->boolean('empty_residence')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('streets');
    }
}
